/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.AttributeKeyAndValue;
import com.amazonaws.services.clouddirectory.model.BatchListObjectAttributesResponse;
import com.amazonaws.services.clouddirectory.model.transform.AttributeKeyAndValueJsonMarshaller;
import java.util.List;

public class BatchListObjectAttributesResponseJsonMarshaller {
    private static BatchListObjectAttributesResponseJsonMarshaller instance;

    public void marshall(BatchListObjectAttributesResponse batchListObjectAttributesResponse, StructuredJsonGenerator jsonGenerator) {
        if (batchListObjectAttributesResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<AttributeKeyAndValue> attributesList = batchListObjectAttributesResponse.getAttributes();
            if (attributesList != null) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartArray();
                for (AttributeKeyAndValue attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeKeyAndValueJsonMarshaller.getInstance().marshall(attributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (batchListObjectAttributesResponse.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(batchListObjectAttributesResponse.getNextToken());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BatchListObjectAttributesResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BatchListObjectAttributesResponseJsonMarshaller();
        }
        return instance;
    }
}

