/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanroomsml.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cleanroomsml.model.Dataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateTrainingDatasetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private String name;
    private String roleArn;
    private Map<String, String> tags;
    private List<Dataset> trainingData;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTrainingDatasetRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTrainingDatasetRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateTrainingDatasetRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateTrainingDatasetRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateTrainingDatasetRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateTrainingDatasetRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<Dataset> getTrainingData() {
        return this.trainingData;
    }

    public void setTrainingData(Collection<Dataset> trainingData) {
        if (trainingData == null) {
            this.trainingData = null;
            return;
        }
        this.trainingData = new ArrayList<Dataset>(trainingData);
    }

    public CreateTrainingDatasetRequest withTrainingData(Dataset ... trainingData) {
        if (this.trainingData == null) {
            this.setTrainingData(new ArrayList<Dataset>(trainingData.length));
        }
        for (Dataset ele : trainingData) {
            this.trainingData.add(ele);
        }
        return this;
    }

    public CreateTrainingDatasetRequest withTrainingData(Collection<Dataset> trainingData) {
        this.setTrainingData(trainingData);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTrainingData() != null) {
            sb.append("TrainingData: ").append(this.getTrainingData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingDatasetRequest)) {
            return false;
        }
        CreateTrainingDatasetRequest other = (CreateTrainingDatasetRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTrainingData() == null ^ this.getTrainingData() == null) {
            return false;
        }
        return other.getTrainingData() == null || other.getTrainingData().equals(this.getTrainingData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingData() == null ? 0 : this.getTrainingData().hashCode());
        return hashCode;
    }

    public CreateTrainingDatasetRequest clone() {
        return (CreateTrainingDatasetRequest)super.clone();
    }
}

