/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cleanrooms.model.BatchGetSchemaError;
import com.amazonaws.services.cleanrooms.model.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetSchemaResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Schema> schemas;
    private List<BatchGetSchemaError> errors;

    public List<Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<Schema> schemas) {
        if (schemas == null) {
            this.schemas = null;
            return;
        }
        this.schemas = new ArrayList<Schema>(schemas);
    }

    public BatchGetSchemaResult withSchemas(Schema ... schemas) {
        if (this.schemas == null) {
            this.setSchemas(new ArrayList<Schema>(schemas.length));
        }
        for (Schema ele : schemas) {
            this.schemas.add(ele);
        }
        return this;
    }

    public BatchGetSchemaResult withSchemas(Collection<Schema> schemas) {
        this.setSchemas(schemas);
        return this;
    }

    public List<BatchGetSchemaError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<BatchGetSchemaError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<BatchGetSchemaError>(errors);
    }

    public BatchGetSchemaResult withErrors(BatchGetSchemaError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<BatchGetSchemaError>(errors.length));
        }
        for (BatchGetSchemaError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetSchemaResult withErrors(Collection<BatchGetSchemaError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSchemas() != null) {
            sb.append("Schemas: ").append(this.getSchemas()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaResult)) {
            return false;
        }
        BatchGetSchemaResult other = (BatchGetSchemaResult)obj;
        if (other.getSchemas() == null ^ this.getSchemas() == null) {
            return false;
        }
        if (other.getSchemas() != null && !other.getSchemas().equals(this.getSchemas())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSchemas() == null ? 0 : this.getSchemas().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetSchemaResult clone() {
        try {
            return (BatchGetSchemaResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

