/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cleanrooms.model.AnalysisMethod;
import com.amazonaws.services.cleanrooms.model.TableReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateConfiguredTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private TableReference tableReference;
    private List<String> allowedColumns;
    private String analysisMethod;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateConfiguredTableRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateConfiguredTableRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTableReference(TableReference tableReference) {
        this.tableReference = tableReference;
    }

    public TableReference getTableReference() {
        return this.tableReference;
    }

    public CreateConfiguredTableRequest withTableReference(TableReference tableReference) {
        this.setTableReference(tableReference);
        return this;
    }

    public List<String> getAllowedColumns() {
        return this.allowedColumns;
    }

    public void setAllowedColumns(Collection<String> allowedColumns) {
        if (allowedColumns == null) {
            this.allowedColumns = null;
            return;
        }
        this.allowedColumns = new ArrayList<String>(allowedColumns);
    }

    public CreateConfiguredTableRequest withAllowedColumns(String ... allowedColumns) {
        if (this.allowedColumns == null) {
            this.setAllowedColumns(new ArrayList<String>(allowedColumns.length));
        }
        for (String ele : allowedColumns) {
            this.allowedColumns.add(ele);
        }
        return this;
    }

    public CreateConfiguredTableRequest withAllowedColumns(Collection<String> allowedColumns) {
        this.setAllowedColumns(allowedColumns);
        return this;
    }

    public void setAnalysisMethod(String analysisMethod) {
        this.analysisMethod = analysisMethod;
    }

    public String getAnalysisMethod() {
        return this.analysisMethod;
    }

    public CreateConfiguredTableRequest withAnalysisMethod(String analysisMethod) {
        this.setAnalysisMethod(analysisMethod);
        return this;
    }

    public CreateConfiguredTableRequest withAnalysisMethod(AnalysisMethod analysisMethod) {
        this.analysisMethod = analysisMethod.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateConfiguredTableRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateConfiguredTableRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateConfiguredTableRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTableReference() != null) {
            sb.append("TableReference: ").append(this.getTableReference()).append(",");
        }
        if (this.getAllowedColumns() != null) {
            sb.append("AllowedColumns: ").append(this.getAllowedColumns()).append(",");
        }
        if (this.getAnalysisMethod() != null) {
            sb.append("AnalysisMethod: ").append(this.getAnalysisMethod()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredTableRequest)) {
            return false;
        }
        CreateConfiguredTableRequest other = (CreateConfiguredTableRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTableReference() == null ^ this.getTableReference() == null) {
            return false;
        }
        if (other.getTableReference() != null && !other.getTableReference().equals(this.getTableReference())) {
            return false;
        }
        if (other.getAllowedColumns() == null ^ this.getAllowedColumns() == null) {
            return false;
        }
        if (other.getAllowedColumns() != null && !other.getAllowedColumns().equals(this.getAllowedColumns())) {
            return false;
        }
        if (other.getAnalysisMethod() == null ^ this.getAnalysisMethod() == null) {
            return false;
        }
        if (other.getAnalysisMethod() != null && !other.getAnalysisMethod().equals(this.getAnalysisMethod())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTableReference() == null ? 0 : this.getTableReference().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedColumns() == null ? 0 : this.getAllowedColumns().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisMethod() == null ? 0 : this.getAnalysisMethod().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateConfiguredTableRequest clone() {
        return (CreateConfiguredTableRequest)super.clone();
    }
}

