/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkmessaging.model.ChannelMessagePersistenceType;
import com.amazonaws.services.chimesdkmessaging.model.ChannelMessageType;
import com.amazonaws.services.chimesdkmessaging.model.MessageAttributeValue;
import com.amazonaws.services.chimesdkmessaging.model.PushNotificationConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SendChannelMessageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelArn;
    private String content;
    private String type;
    private String persistence;
    private String metadata;
    private String clientRequestToken;
    private String chimeBearer;
    private PushNotificationConfiguration pushNotification;
    private Map<String, MessageAttributeValue> messageAttributes;
    private String subChannelId;
    private String contentType;

    public void setChannelArn(String channelArn) {
        this.channelArn = channelArn;
    }

    public String getChannelArn() {
        return this.channelArn;
    }

    public SendChannelMessageRequest withChannelArn(String channelArn) {
        this.setChannelArn(channelArn);
        return this;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public SendChannelMessageRequest withContent(String content) {
        this.setContent(content);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public SendChannelMessageRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public SendChannelMessageRequest withType(ChannelMessageType type) {
        this.type = type.toString();
        return this;
    }

    public void setPersistence(String persistence) {
        this.persistence = persistence;
    }

    public String getPersistence() {
        return this.persistence;
    }

    public SendChannelMessageRequest withPersistence(String persistence) {
        this.setPersistence(persistence);
        return this;
    }

    public SendChannelMessageRequest withPersistence(ChannelMessagePersistenceType persistence) {
        this.persistence = persistence.toString();
        return this;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public SendChannelMessageRequest withMetadata(String metadata) {
        this.setMetadata(metadata);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public SendChannelMessageRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setChimeBearer(String chimeBearer) {
        this.chimeBearer = chimeBearer;
    }

    public String getChimeBearer() {
        return this.chimeBearer;
    }

    public SendChannelMessageRequest withChimeBearer(String chimeBearer) {
        this.setChimeBearer(chimeBearer);
        return this;
    }

    public void setPushNotification(PushNotificationConfiguration pushNotification) {
        this.pushNotification = pushNotification;
    }

    public PushNotificationConfiguration getPushNotification() {
        return this.pushNotification;
    }

    public SendChannelMessageRequest withPushNotification(PushNotificationConfiguration pushNotification) {
        this.setPushNotification(pushNotification);
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes;
    }

    public SendChannelMessageRequest withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.setMessageAttributes(messageAttributes);
        return this;
    }

    public SendChannelMessageRequest addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new HashMap<String, MessageAttributeValue>();
        }
        if (this.messageAttributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put(key, value);
        return this;
    }

    public SendChannelMessageRequest clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public void setSubChannelId(String subChannelId) {
        this.subChannelId = subChannelId;
    }

    public String getSubChannelId() {
        return this.subChannelId;
    }

    public SendChannelMessageRequest withSubChannelId(String subChannelId) {
        this.setSubChannelId(subChannelId);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SendChannelMessageRequest withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelArn() != null) {
            sb.append("ChannelArn: ").append(this.getChannelArn()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPersistence() != null) {
            sb.append("Persistence: ").append(this.getPersistence()).append(",");
        }
        if (this.getMetadata() != null) {
            sb.append("Metadata: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getChimeBearer() != null) {
            sb.append("ChimeBearer: ").append(this.getChimeBearer()).append(",");
        }
        if (this.getPushNotification() != null) {
            sb.append("PushNotification: ").append(this.getPushNotification()).append(",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSubChannelId() != null) {
            sb.append("SubChannelId: ").append(this.getSubChannelId()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChannelMessageRequest)) {
            return false;
        }
        SendChannelMessageRequest other = (SendChannelMessageRequest)obj;
        if (other.getChannelArn() == null ^ this.getChannelArn() == null) {
            return false;
        }
        if (other.getChannelArn() != null && !other.getChannelArn().equals(this.getChannelArn())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPersistence() == null ^ this.getPersistence() == null) {
            return false;
        }
        if (other.getPersistence() != null && !other.getPersistence().equals(this.getPersistence())) {
            return false;
        }
        if (other.getMetadata() == null ^ this.getMetadata() == null) {
            return false;
        }
        if (other.getMetadata() != null && !other.getMetadata().equals(this.getMetadata())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getChimeBearer() == null ^ this.getChimeBearer() == null) {
            return false;
        }
        if (other.getChimeBearer() != null && !other.getChimeBearer().equals(this.getChimeBearer())) {
            return false;
        }
        if (other.getPushNotification() == null ^ this.getPushNotification() == null) {
            return false;
        }
        if (other.getPushNotification() != null && !other.getPushNotification().equals(this.getPushNotification())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        if (other.getMessageAttributes() != null && !other.getMessageAttributes().equals(this.getMessageAttributes())) {
            return false;
        }
        if (other.getSubChannelId() == null ^ this.getSubChannelId() == null) {
            return false;
        }
        if (other.getSubChannelId() != null && !other.getSubChannelId().equals(this.getSubChannelId())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        return other.getContentType() == null || other.getContentType().equals(this.getContentType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelArn() == null ? 0 : this.getChannelArn().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPersistence() == null ? 0 : this.getPersistence().hashCode());
        hashCode = 31 * hashCode + (this.getMetadata() == null ? 0 : this.getMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getChimeBearer() == null ? 0 : this.getChimeBearer().hashCode());
        hashCode = 31 * hashCode + (this.getPushNotification() == null ? 0 : this.getPushNotification().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSubChannelId() == null ? 0 : this.getSubChannelId().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        return hashCode;
    }

    public SendChannelMessageRequest clone() {
        return (SendChannelMessageRequest)super.clone();
    }
}

