/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-messaging-2021-05-15/DeleteChannelMembership"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DeleteChannelMembershipRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The ARN of the channel from which you want to remove the user.
     * </p>
     */
    private String channelArn;
    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     * </p>
     */
    private String memberArn;
    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     */
    private String chimeBearer;
    /**
     * <p>
     * The ID of the SubChannel in the request.
     * </p>
     * <note>
     * <p>
     * Only for use by moderators.
     * </p>
     * </note>
     */
    private String subChannelId;

    /**
     * <p>
     * The ARN of the channel from which you want to remove the user.
     * </p>
     * 
     * @param channelArn
     *        The ARN of the channel from which you want to remove the user.
     */

    public void setChannelArn(String channelArn) {
        this.channelArn = channelArn;
    }

    /**
     * <p>
     * The ARN of the channel from which you want to remove the user.
     * </p>
     * 
     * @return The ARN of the channel from which you want to remove the user.
     */

    public String getChannelArn() {
        return this.channelArn;
    }

    /**
     * <p>
     * The ARN of the channel from which you want to remove the user.
     * </p>
     * 
     * @param channelArn
     *        The ARN of the channel from which you want to remove the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteChannelMembershipRequest withChannelArn(String channelArn) {
        setChannelArn(channelArn);
        return this;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     * </p>
     * 
     * @param memberArn
     *        The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     */

    public void setMemberArn(String memberArn) {
        this.memberArn = memberArn;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     */

    public String getMemberArn() {
        return this.memberArn;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     * </p>
     * 
     * @param memberArn
     *        The <code>AppInstanceUserArn</code> of the member that you're removing from the channel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteChannelMembershipRequest withMemberArn(String memberArn) {
        setMemberArn(memberArn);
        return this;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @param chimeBearer
     *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */

    public void setChimeBearer(String chimeBearer) {
        this.chimeBearer = chimeBearer;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */

    public String getChimeBearer() {
        return this.chimeBearer;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @param chimeBearer
     *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteChannelMembershipRequest withChimeBearer(String chimeBearer) {
        setChimeBearer(chimeBearer);
        return this;
    }

    /**
     * <p>
     * The ID of the SubChannel in the request.
     * </p>
     * <note>
     * <p>
     * Only for use by moderators.
     * </p>
     * </note>
     * 
     * @param subChannelId
     *        The ID of the SubChannel in the request.</p> <note>
     *        <p>
     *        Only for use by moderators.
     *        </p>
     */

    public void setSubChannelId(String subChannelId) {
        this.subChannelId = subChannelId;
    }

    /**
     * <p>
     * The ID of the SubChannel in the request.
     * </p>
     * <note>
     * <p>
     * Only for use by moderators.
     * </p>
     * </note>
     * 
     * @return The ID of the SubChannel in the request.</p> <note>
     *         <p>
     *         Only for use by moderators.
     *         </p>
     */

    public String getSubChannelId() {
        return this.subChannelId;
    }

    /**
     * <p>
     * The ID of the SubChannel in the request.
     * </p>
     * <note>
     * <p>
     * Only for use by moderators.
     * </p>
     * </note>
     * 
     * @param subChannelId
     *        The ID of the SubChannel in the request.</p> <note>
     *        <p>
     *        Only for use by moderators.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DeleteChannelMembershipRequest withSubChannelId(String subChannelId) {
        setSubChannelId(subChannelId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getChannelArn() != null)
            sb.append("ChannelArn: ").append(getChannelArn()).append(",");
        if (getMemberArn() != null)
            sb.append("MemberArn: ").append(getMemberArn()).append(",");
        if (getChimeBearer() != null)
            sb.append("ChimeBearer: ").append(getChimeBearer()).append(",");
        if (getSubChannelId() != null)
            sb.append("SubChannelId: ").append(getSubChannelId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DeleteChannelMembershipRequest == false)
            return false;
        DeleteChannelMembershipRequest other = (DeleteChannelMembershipRequest) obj;
        if (other.getChannelArn() == null ^ this.getChannelArn() == null)
            return false;
        if (other.getChannelArn() != null && other.getChannelArn().equals(this.getChannelArn()) == false)
            return false;
        if (other.getMemberArn() == null ^ this.getMemberArn() == null)
            return false;
        if (other.getMemberArn() != null && other.getMemberArn().equals(this.getMemberArn()) == false)
            return false;
        if (other.getChimeBearer() == null ^ this.getChimeBearer() == null)
            return false;
        if (other.getChimeBearer() != null && other.getChimeBearer().equals(this.getChimeBearer()) == false)
            return false;
        if (other.getSubChannelId() == null ^ this.getSubChannelId() == null)
            return false;
        if (other.getSubChannelId() != null && other.getSubChannelId().equals(this.getSubChannelId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getChannelArn() == null) ? 0 : getChannelArn().hashCode());
        hashCode = prime * hashCode + ((getMemberArn() == null) ? 0 : getMemberArn().hashCode());
        hashCode = prime * hashCode + ((getChimeBearer() == null) ? 0 : getChimeBearer().hashCode());
        hashCode = prime * hashCode + ((getSubChannelId() == null) ? 0 : getSubChannelId().hashCode());
        return hashCode;
    }

    @Override
    public DeleteChannelMembershipRequest clone() {
        return (DeleteChannelMembershipRequest) super.clone();
    }

}
