/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkmediapipelines.model.transform.KeywordMatchConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KeywordMatchConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleName;
    private List<String> keywords;
    private Boolean negate;

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public KeywordMatchConfiguration withRuleName(String ruleName) {
        this.setRuleName(ruleName);
        return this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Collection<String> keywords) {
        if (keywords == null) {
            this.keywords = null;
            return;
        }
        this.keywords = new ArrayList<String>(keywords);
    }

    public KeywordMatchConfiguration withKeywords(String ... keywords) {
        if (this.keywords == null) {
            this.setKeywords(new ArrayList<String>(keywords.length));
        }
        for (String ele : keywords) {
            this.keywords.add(ele);
        }
        return this;
    }

    public KeywordMatchConfiguration withKeywords(Collection<String> keywords) {
        this.setKeywords(keywords);
        return this;
    }

    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    public Boolean getNegate() {
        return this.negate;
    }

    public KeywordMatchConfiguration withNegate(Boolean negate) {
        this.setNegate(negate);
        return this;
    }

    public Boolean isNegate() {
        return this.negate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleName() != null) {
            sb.append("RuleName: ").append(this.getRuleName()).append(",");
        }
        if (this.getKeywords() != null) {
            sb.append("Keywords: ").append(this.getKeywords()).append(",");
        }
        if (this.getNegate() != null) {
            sb.append("Negate: ").append(this.getNegate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeywordMatchConfiguration)) {
            return false;
        }
        KeywordMatchConfiguration other = (KeywordMatchConfiguration)obj;
        if (other.getRuleName() == null ^ this.getRuleName() == null) {
            return false;
        }
        if (other.getRuleName() != null && !other.getRuleName().equals(this.getRuleName())) {
            return false;
        }
        if (other.getKeywords() == null ^ this.getKeywords() == null) {
            return false;
        }
        if (other.getKeywords() != null && !other.getKeywords().equals(this.getKeywords())) {
            return false;
        }
        if (other.getNegate() == null ^ this.getNegate() == null) {
            return false;
        }
        return other.getNegate() == null || other.getNegate().equals(this.getNegate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleName() == null ? 0 : this.getRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getKeywords() == null ? 0 : this.getKeywords().hashCode());
        hashCode = 31 * hashCode + (this.getNegate() == null ? 0 : this.getNegate().hashCode());
        return hashCode;
    }

    public KeywordMatchConfiguration clone() {
        try {
            return (KeywordMatchConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeywordMatchConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

