/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A summary of the media insights pipeline configuration.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/MediaInsightsPipelineConfigurationSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MediaInsightsPipelineConfigurationSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     */
    private String mediaInsightsPipelineConfigurationName;
    /**
     * <p>
     * The ID of the media insights pipeline configuration.
     * </p>
     */
    private String mediaInsightsPipelineConfigurationId;
    /**
     * <p>
     * The ARN of the media insights pipeline configuration.
     * </p>
     */
    private String mediaInsightsPipelineConfigurationArn;

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationName
     *        The name of the media insights pipeline configuration.
     */

    public void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
        this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
    }

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     * 
     * @return The name of the media insights pipeline configuration.
     */

    public String getMediaInsightsPipelineConfigurationName() {
        return this.mediaInsightsPipelineConfigurationName;
    }

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationName
     *        The name of the media insights pipeline configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MediaInsightsPipelineConfigurationSummary withMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
        setMediaInsightsPipelineConfigurationName(mediaInsightsPipelineConfigurationName);
        return this;
    }

    /**
     * <p>
     * The ID of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationId
     *        The ID of the media insights pipeline configuration.
     */

    public void setMediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
        this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
    }

    /**
     * <p>
     * The ID of the media insights pipeline configuration.
     * </p>
     * 
     * @return The ID of the media insights pipeline configuration.
     */

    public String getMediaInsightsPipelineConfigurationId() {
        return this.mediaInsightsPipelineConfigurationId;
    }

    /**
     * <p>
     * The ID of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationId
     *        The ID of the media insights pipeline configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MediaInsightsPipelineConfigurationSummary withMediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
        setMediaInsightsPipelineConfigurationId(mediaInsightsPipelineConfigurationId);
        return this;
    }

    /**
     * <p>
     * The ARN of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationArn
     *        The ARN of the media insights pipeline configuration.
     */

    public void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
        this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
    }

    /**
     * <p>
     * The ARN of the media insights pipeline configuration.
     * </p>
     * 
     * @return The ARN of the media insights pipeline configuration.
     */

    public String getMediaInsightsPipelineConfigurationArn() {
        return this.mediaInsightsPipelineConfigurationArn;
    }

    /**
     * <p>
     * The ARN of the media insights pipeline configuration.
     * </p>
     * 
     * @param mediaInsightsPipelineConfigurationArn
     *        The ARN of the media insights pipeline configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MediaInsightsPipelineConfigurationSummary withMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
        setMediaInsightsPipelineConfigurationArn(mediaInsightsPipelineConfigurationArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMediaInsightsPipelineConfigurationName() != null)
            sb.append("MediaInsightsPipelineConfigurationName: ").append(getMediaInsightsPipelineConfigurationName()).append(",");
        if (getMediaInsightsPipelineConfigurationId() != null)
            sb.append("MediaInsightsPipelineConfigurationId: ").append(getMediaInsightsPipelineConfigurationId()).append(",");
        if (getMediaInsightsPipelineConfigurationArn() != null)
            sb.append("MediaInsightsPipelineConfigurationArn: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MediaInsightsPipelineConfigurationSummary == false)
            return false;
        MediaInsightsPipelineConfigurationSummary other = (MediaInsightsPipelineConfigurationSummary) obj;
        if (other.getMediaInsightsPipelineConfigurationName() == null ^ this.getMediaInsightsPipelineConfigurationName() == null)
            return false;
        if (other.getMediaInsightsPipelineConfigurationName() != null
                && other.getMediaInsightsPipelineConfigurationName().equals(this.getMediaInsightsPipelineConfigurationName()) == false)
            return false;
        if (other.getMediaInsightsPipelineConfigurationId() == null ^ this.getMediaInsightsPipelineConfigurationId() == null)
            return false;
        if (other.getMediaInsightsPipelineConfigurationId() != null
                && other.getMediaInsightsPipelineConfigurationId().equals(this.getMediaInsightsPipelineConfigurationId()) == false)
            return false;
        if (other.getMediaInsightsPipelineConfigurationArn() == null ^ this.getMediaInsightsPipelineConfigurationArn() == null)
            return false;
        if (other.getMediaInsightsPipelineConfigurationArn() != null
                && other.getMediaInsightsPipelineConfigurationArn().equals(this.getMediaInsightsPipelineConfigurationArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMediaInsightsPipelineConfigurationName() == null) ? 0 : getMediaInsightsPipelineConfigurationName().hashCode());
        hashCode = prime * hashCode + ((getMediaInsightsPipelineConfigurationId() == null) ? 0 : getMediaInsightsPipelineConfigurationId().hashCode());
        hashCode = prime * hashCode + ((getMediaInsightsPipelineConfigurationArn() == null) ? 0 : getMediaInsightsPipelineConfigurationArn().hashCode());
        return hashCode;
    }

    @Override
    public MediaInsightsPipelineConfigurationSummary clone() {
        try {
            return (MediaInsightsPipelineConfigurationSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.chimesdkmediapipelines.model.transform.MediaInsightsPipelineConfigurationSummaryMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
