/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chime.model.MeetingNotificationConfiguration;
import com.amazonaws.services.chime.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMeetingRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private String externalMeetingId;
    private String meetingHostId;
    private String mediaRegion;
    private List<Tag> tags;
    private MeetingNotificationConfiguration notificationsConfiguration;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateMeetingRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setExternalMeetingId(String externalMeetingId) {
        this.externalMeetingId = externalMeetingId;
    }

    public String getExternalMeetingId() {
        return this.externalMeetingId;
    }

    public CreateMeetingRequest withExternalMeetingId(String externalMeetingId) {
        this.setExternalMeetingId(externalMeetingId);
        return this;
    }

    public void setMeetingHostId(String meetingHostId) {
        this.meetingHostId = meetingHostId;
    }

    public String getMeetingHostId() {
        return this.meetingHostId;
    }

    public CreateMeetingRequest withMeetingHostId(String meetingHostId) {
        this.setMeetingHostId(meetingHostId);
        return this;
    }

    public void setMediaRegion(String mediaRegion) {
        this.mediaRegion = mediaRegion;
    }

    public String getMediaRegion() {
        return this.mediaRegion;
    }

    public CreateMeetingRequest withMediaRegion(String mediaRegion) {
        this.setMediaRegion(mediaRegion);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateMeetingRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateMeetingRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setNotificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration) {
        this.notificationsConfiguration = notificationsConfiguration;
    }

    public MeetingNotificationConfiguration getNotificationsConfiguration() {
        return this.notificationsConfiguration;
    }

    public CreateMeetingRequest withNotificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration) {
        this.setNotificationsConfiguration(notificationsConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExternalMeetingId() != null) {
            sb.append("ExternalMeetingId: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMeetingHostId() != null) {
            sb.append("MeetingHostId: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getMediaRegion() != null) {
            sb.append("MediaRegion: ").append(this.getMediaRegion()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getNotificationsConfiguration() != null) {
            sb.append("NotificationsConfiguration: ").append(this.getNotificationsConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingRequest)) {
            return false;
        }
        CreateMeetingRequest other = (CreateMeetingRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getExternalMeetingId() == null ^ this.getExternalMeetingId() == null) {
            return false;
        }
        if (other.getExternalMeetingId() != null && !other.getExternalMeetingId().equals(this.getExternalMeetingId())) {
            return false;
        }
        if (other.getMeetingHostId() == null ^ this.getMeetingHostId() == null) {
            return false;
        }
        if (other.getMeetingHostId() != null && !other.getMeetingHostId().equals(this.getMeetingHostId())) {
            return false;
        }
        if (other.getMediaRegion() == null ^ this.getMediaRegion() == null) {
            return false;
        }
        if (other.getMediaRegion() != null && !other.getMediaRegion().equals(this.getMediaRegion())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getNotificationsConfiguration() == null ^ this.getNotificationsConfiguration() == null) {
            return false;
        }
        return other.getNotificationsConfiguration() == null || other.getNotificationsConfiguration().equals(this.getNotificationsConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getExternalMeetingId() == null ? 0 : this.getExternalMeetingId().hashCode());
        hashCode = 31 * hashCode + (this.getMeetingHostId() == null ? 0 : this.getMeetingHostId().hashCode());
        hashCode = 31 * hashCode + (this.getMediaRegion() == null ? 0 : this.getMediaRegion().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationsConfiguration() == null ? 0 : this.getNotificationsConfiguration().hashCode());
        return hashCode;
    }

    public CreateMeetingRequest clone() {
        return (CreateMeetingRequest)super.clone();
    }
}

