/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.Member;

@SdkInternalApi
public class MemberMarshaller {
    private static final MarshallingInfo<String> MEMBERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemberId").build();
    private static final MarshallingInfo<String> MEMBERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemberType").build();
    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").build();
    private static final MarshallingInfo<String> FULLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FullName").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MemberMarshaller instance = new MemberMarshaller();

    public static MemberMarshaller getInstance() {
        return instance;
    }

    public void marshall(Member member, ProtocolMarshaller protocolMarshaller) {
        if (member == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)member.getMemberId(), MEMBERID_BINDING);
            protocolMarshaller.marshall((Object)member.getMemberType(), MEMBERTYPE_BINDING);
            protocolMarshaller.marshall((Object)member.getEmail(), EMAIL_BINDING);
            protocolMarshaller.marshall((Object)member.getFullName(), FULLNAME_BINDING);
            protocolMarshaller.marshall((Object)member.getAccountId(), ACCOUNTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

