/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.devopsguru.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code>
 * dimension group consists of the following dimensions: <code>db.sql.id</code>, <code>db.sql.db_id</code>,
 * <code>db.sql.statement</code>, and <code>db.sql.tokenized_id</code>.
 * </p>
 * <note>
 * <p>
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500
 * bytes are returned.
 * </p>
 * </note>
 * <p>
 * Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on
 * data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights
 * provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data
 * for each time point in the queried time range. Each time point decomposes overall load in relation to the requested
 * dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host.
 * </p>
 * <ul>
 * <li>
 * <p>
 * To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User
 * Guide</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * To learn more about Performance Insights and Amazon RDS DB instances, go to the <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>.
 * </p>
 * </li>
 * </ul>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PerformanceInsightsMetricDimensionGroup"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PerformanceInsightsMetricDimensionGroup implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the dimension group. Its valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
     * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The SQL that is currently executing (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines)
     * </p>
     * </li>
     * </ul>
     */
    private String group;
    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon
     * RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)
     * </p>
     * </li>
     * </ul>
     */
    private java.util.List<String> dimensions;
    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     */
    private Integer limit;

    /**
     * <p>
     * The name of the dimension group. Its valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
     * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The SQL that is currently executing (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @param group
     *        The name of the dimension group. Its valid values are:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *        Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     *        PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host</code> - The host name of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql</code> - The SQL that is currently executing (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized</code> - The SQL digest (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all
     *        engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user</code> - The user logged in to the database (all engines)
     *        </p>
     *        </li>
     */

    public void setGroup(String group) {
        this.group = group;
    }

    /**
     * <p>
     * The name of the dimension group. Its valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
     * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The SQL that is currently executing (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the dimension group. Its valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *         Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     *         PostgreSQL and RDS PostgreSQL)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host</code> - The host name of the connected client (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *         PostgreSQL)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql</code> - The SQL that is currently executing (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized</code> - The SQL digest (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all
     *         engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user</code> - The user logged in to the database (all engines)
     *         </p>
     *         </li>
     */

    public String getGroup() {
        return this.group;
    }

    /**
     * <p>
     * The name of the dimension group. Its valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS
     * PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql</code> - The SQL that is currently executing (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized</code> - The SQL digest (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user</code> - The user logged in to the database (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @param group
     *        The name of the dimension group. Its valid values are:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *        Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.application</code> - The name of the application that is connected to the database (only Aurora
     *        PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host</code> - The host name of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql</code> - The SQL that is currently executing (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized</code> - The SQL digest (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all
     *        engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user</code> - The user logged in to the database (all engines)
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withGroup(String group) {
        setGroup(group);
        return this;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon
     * RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *         that all of the dimensions in the group were requested or are present in the response.</p>
     *         <p>
     *         Valid values for elements in the <code>Dimensions</code> array are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>db.application.name</code> - The name of the application that is connected to the database (only
     *         Aurora PostgreSQL and RDS PostgreSQL)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host.id</code> - The host ID of the connected client (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.host.name</code> - The host name of the connected client (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *         Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *         PostgreSQL)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql.tokenized_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *         engines)
     *         </p>
     *         </li>
     */

    public java.util.List<String> getDimensions() {
        return dimensions;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon
     * RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database (only
     *        Aurora PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *        Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *        PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines)
     *        </p>
     *        </li>
     */

    public void setDimensions(java.util.Collection<String> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }

        this.dimensions = new java.util.ArrayList<String>(dimensions);
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon
     * RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDimensions(java.util.Collection)} or {@link #withDimensions(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database (only
     *        Aurora PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *        Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *        PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines)
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withDimensions(String... dimensions) {
        if (this.dimensions == null) {
            setDimensions(new java.util.ArrayList<String>(dimensions.length));
        }
        for (String ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that
     * all of the dimensions in the group were requested or are present in the response.
     * </p>
     * <p>
     * Valid values for elements in the <code>Dimensions</code> array are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora
     * PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.id</code> - The host ID of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.host.name</code> - The host name of the connected client (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon
     * RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql.tokenized_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)
     * </p>
     * </li>
     * </ul>
     * 
     * @param dimensions
     *        A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies
     *        that all of the dimensions in the group were requested or are present in the response.</p>
     *        <p>
     *        Valid values for elements in the <code>Dimensions</code> array are:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>db.application.name</code> - The name of the application that is connected to the database (only
     *        Aurora PostgreSQL and RDS PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.id</code> - The host ID of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.host.name</code> - The host name of the connected client (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL,
     *        Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS
     *        PostgreSQL)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.statement</code> - The SQL text that is being executed (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql.tokenized_id</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.id</code> - The ID of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.user.name</code> - The name of the user logged in to the database (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all
     *        engines)
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withDimensions(java.util.Collection<String> dimensions) {
        setDimensions(dimensions);
        return this;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     */

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @return The maximum number of items to fetch for this dimension group.
     */

    public Integer getLimit() {
        return this.limit;
    }

    /**
     * <p>
     * The maximum number of items to fetch for this dimension group.
     * </p>
     * 
     * @param limit
     *        The maximum number of items to fetch for this dimension group.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public PerformanceInsightsMetricDimensionGroup withLimit(Integer limit) {
        setLimit(limit);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getGroup() != null)
            sb.append("Group: ").append(getGroup()).append(",");
        if (getDimensions() != null)
            sb.append("Dimensions: ").append(getDimensions()).append(",");
        if (getLimit() != null)
            sb.append("Limit: ").append(getLimit());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof PerformanceInsightsMetricDimensionGroup == false)
            return false;
        PerformanceInsightsMetricDimensionGroup other = (PerformanceInsightsMetricDimensionGroup) obj;
        if (other.getGroup() == null ^ this.getGroup() == null)
            return false;
        if (other.getGroup() != null && other.getGroup().equals(this.getGroup()) == false)
            return false;
        if (other.getDimensions() == null ^ this.getDimensions() == null)
            return false;
        if (other.getDimensions() != null && other.getDimensions().equals(this.getDimensions()) == false)
            return false;
        if (other.getLimit() == null ^ this.getLimit() == null)
            return false;
        if (other.getLimit() != null && other.getLimit().equals(this.getLimit()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getGroup() == null) ? 0 : getGroup().hashCode());
        hashCode = prime * hashCode + ((getDimensions() == null) ? 0 : getDimensions().hashCode());
        hashCode = prime * hashCode + ((getLimit() == null) ? 0 : getLimit().hashCode());
        return hashCode;
    }

    @Override
    public PerformanceInsightsMetricDimensionGroup clone() {
        try {
            return (PerformanceInsightsMetricDimensionGroup) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.devopsguru.model.transform.PerformanceInsightsMetricDimensionGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
