/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.SolutionStackDescription;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class SolutionStackDescriptionStaxUnmarshaller
implements Unmarshaller<SolutionStackDescription, StaxUnmarshallerContext> {
    private static SolutionStackDescriptionStaxUnmarshaller instance;

    @Override
    public SolutionStackDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        SolutionStackDescription solutionStackDescription = new SolutionStackDescription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return solutionStackDescription;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SolutionStackName", targetDepth)) {
                    solutionStackDescription.setSolutionStackName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PermittedFileTypes", targetDepth)) {
                    solutionStackDescription.withPermittedFileTypes(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("PermittedFileTypes/member", targetDepth)) continue;
                solutionStackDescription.withPermittedFileTypes(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return solutionStackDescription;
    }

    public static SolutionStackDescriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SolutionStackDescriptionStaxUnmarshaller();
        }
        return instance;
    }
}

