/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.Ulimit;

@SdkInternalApi
public class UlimitMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Integer> SOFTLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softLimit").build();
    private static final MarshallingInfo<Integer> HARDLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hardLimit").build();
    private static final UlimitMarshaller instance = new UlimitMarshaller();

    public static UlimitMarshaller getInstance() {
        return instance;
    }

    public void marshall(Ulimit ulimit, ProtocolMarshaller protocolMarshaller) {
        if (ulimit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ulimit.getName(), NAME_BINDING);
            protocolMarshaller.marshall(ulimit.getSoftLimit(), SOFTLIMIT_BINDING);
            protocolMarshaller.marshall(ulimit.getHardLimit(), HARDLIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

