/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.UpdateNFSFileShareRequest;
import com.amazonaws.services.storagegateway.model.transform.NFSFileShareDefaultsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateNFSFileShareRequestMarshaller
implements Marshaller<Request<UpdateNFSFileShareRequest>, UpdateNFSFileShareRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateNFSFileShareRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateNFSFileShareRequest> marshall(UpdateNFSFileShareRequest updateNFSFileShareRequest) {
        if (updateNFSFileShareRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateNFSFileShareRequest> request = new DefaultRequest<UpdateNFSFileShareRequest>(updateNFSFileShareRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.UpdateNFSFileShare");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList clientListList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateNFSFileShareRequest.getFileShareARN() != null) {
                jsonGenerator.writeFieldName("FileShareARN").writeValue(updateNFSFileShareRequest.getFileShareARN());
            }
            if (updateNFSFileShareRequest.getKMSEncrypted() != null) {
                jsonGenerator.writeFieldName("KMSEncrypted").writeValue(updateNFSFileShareRequest.getKMSEncrypted());
            }
            if (updateNFSFileShareRequest.getKMSKey() != null) {
                jsonGenerator.writeFieldName("KMSKey").writeValue(updateNFSFileShareRequest.getKMSKey());
            }
            if (updateNFSFileShareRequest.getNFSFileShareDefaults() != null) {
                jsonGenerator.writeFieldName("NFSFileShareDefaults");
                NFSFileShareDefaultsJsonMarshaller.getInstance().marshall(updateNFSFileShareRequest.getNFSFileShareDefaults(), jsonGenerator);
            }
            if (updateNFSFileShareRequest.getDefaultStorageClass() != null) {
                jsonGenerator.writeFieldName("DefaultStorageClass").writeValue(updateNFSFileShareRequest.getDefaultStorageClass());
            }
            if (!(clientListList = (SdkInternalList)updateNFSFileShareRequest.getClientList()).isEmpty() || !clientListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ClientList");
                jsonGenerator.writeStartArray();
                for (String clientListListValue : clientListList) {
                    if (clientListListValue == null) continue;
                    jsonGenerator.writeValue(clientListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

