/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.Alarm;
import com.amazonaws.services.codedeploy.model.AlarmConfiguration;
import com.amazonaws.services.codedeploy.model.transform.AlarmJsonMarshaller;

public class AlarmConfigurationJsonMarshaller {
    private static AlarmConfigurationJsonMarshaller instance;

    public void marshall(AlarmConfiguration alarmConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (alarmConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList alarmsList;
            jsonGenerator.writeStartObject();
            if (alarmConfiguration.getEnabled() != null) {
                jsonGenerator.writeFieldName("enabled").writeValue(alarmConfiguration.getEnabled());
            }
            if (alarmConfiguration.getIgnorePollAlarmFailure() != null) {
                jsonGenerator.writeFieldName("ignorePollAlarmFailure").writeValue(alarmConfiguration.getIgnorePollAlarmFailure());
            }
            if (!(alarmsList = (SdkInternalList)alarmConfiguration.getAlarms()).isEmpty() || !alarmsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("alarms");
                jsonGenerator.writeStartArray();
                for (Alarm alarmsListValue : alarmsList) {
                    if (alarmsListValue == null) continue;
                    AlarmJsonMarshaller.getInstance().marshall(alarmsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AlarmConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AlarmConfigurationJsonMarshaller();
        }
        return instance;
    }
}

