/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.DataResource;
import com.amazonaws.services.cloudtrail.model.EventSelector;
import com.amazonaws.services.cloudtrail.model.transform.DataResourceJsonMarshaller;

public class EventSelectorJsonMarshaller {
    private static EventSelectorJsonMarshaller instance;

    public void marshall(EventSelector eventSelector, StructuredJsonGenerator jsonGenerator) {
        if (eventSelector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dataResourcesList;
            jsonGenerator.writeStartObject();
            if (eventSelector.getReadWriteType() != null) {
                jsonGenerator.writeFieldName("ReadWriteType").writeValue(eventSelector.getReadWriteType());
            }
            if (eventSelector.getIncludeManagementEvents() != null) {
                jsonGenerator.writeFieldName("IncludeManagementEvents").writeValue(eventSelector.getIncludeManagementEvents());
            }
            if (!(dataResourcesList = (SdkInternalList)eventSelector.getDataResources()).isEmpty() || !dataResourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DataResources");
                jsonGenerator.writeStartArray();
                for (DataResource dataResourcesListValue : dataResourcesList) {
                    if (dataResourcesListValue == null) continue;
                    DataResourceJsonMarshaller.getInstance().marshall(dataResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventSelectorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventSelectorJsonMarshaller();
        }
        return instance;
    }
}

