/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.services.clouddirectory.model.ObjectAttributeUpdate;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateObjectAttributes
implements Serializable,
Cloneable {
    private ObjectReference objectReference;
    private List<ObjectAttributeUpdate> attributeUpdates;

    public void setObjectReference(ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    public BatchUpdateObjectAttributes withObjectReference(ObjectReference objectReference) {
        this.setObjectReference(objectReference);
        return this;
    }

    public List<ObjectAttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    public void setAttributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
        if (attributeUpdates == null) {
            this.attributeUpdates = null;
            return;
        }
        this.attributeUpdates = new ArrayList<ObjectAttributeUpdate>(attributeUpdates);
    }

    public BatchUpdateObjectAttributes withAttributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
        if (this.attributeUpdates == null) {
            this.setAttributeUpdates(new ArrayList<ObjectAttributeUpdate>(attributeUpdates.length));
        }
        for (ObjectAttributeUpdate ele : attributeUpdates) {
            this.attributeUpdates.add(ele);
        }
        return this;
    }

    public BatchUpdateObjectAttributes withAttributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
        this.setAttributeUpdates(attributeUpdates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getObjectReference() != null) {
            sb.append("ObjectReference: ").append(this.getObjectReference()).append(",");
        }
        if (this.getAttributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.getAttributeUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateObjectAttributes)) {
            return false;
        }
        BatchUpdateObjectAttributes other = (BatchUpdateObjectAttributes)obj;
        if (other.getObjectReference() == null ^ this.getObjectReference() == null) {
            return false;
        }
        if (other.getObjectReference() != null && !other.getObjectReference().equals(this.getObjectReference())) {
            return false;
        }
        if (other.getAttributeUpdates() == null ^ this.getAttributeUpdates() == null) {
            return false;
        }
        return other.getAttributeUpdates() == null || other.getAttributeUpdates().equals(this.getAttributeUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getObjectReference() == null ? 0 : this.getObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeUpdates() == null ? 0 : this.getAttributeUpdates().hashCode());
        return hashCode;
    }

    public BatchUpdateObjectAttributes clone() {
        try {
            return (BatchUpdateObjectAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

