/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.Clip;
import com.amazonaws.services.elastictranscoder.model.JobOutput;
import com.amazonaws.services.elastictranscoder.model.JobWatermark;
import com.amazonaws.services.elastictranscoder.model.transform.CaptionsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ClipJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobAlbumArtJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.JobWatermarkJsonMarshaller;

public class JobOutputJsonMarshaller {
    private static JobOutputJsonMarshaller instance;

    public void marshall(JobOutput jobOutput, StructuredJsonGenerator jsonGenerator) {
        if (jobOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList compositionList;
            SdkInternalList watermarksList;
            jsonGenerator.writeStartObject();
            if (jobOutput.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(jobOutput.getId());
            }
            if (jobOutput.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(jobOutput.getKey());
            }
            if (jobOutput.getThumbnailPattern() != null) {
                jsonGenerator.writeFieldName("ThumbnailPattern").writeValue(jobOutput.getThumbnailPattern());
            }
            if (jobOutput.getThumbnailEncryption() != null) {
                jsonGenerator.writeFieldName("ThumbnailEncryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobOutput.getThumbnailEncryption(), jsonGenerator);
            }
            if (jobOutput.getRotate() != null) {
                jsonGenerator.writeFieldName("Rotate").writeValue(jobOutput.getRotate());
            }
            if (jobOutput.getPresetId() != null) {
                jsonGenerator.writeFieldName("PresetId").writeValue(jobOutput.getPresetId());
            }
            if (jobOutput.getSegmentDuration() != null) {
                jsonGenerator.writeFieldName("SegmentDuration").writeValue(jobOutput.getSegmentDuration());
            }
            if (jobOutput.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(jobOutput.getStatus());
            }
            if (jobOutput.getStatusDetail() != null) {
                jsonGenerator.writeFieldName("StatusDetail").writeValue(jobOutput.getStatusDetail());
            }
            if (jobOutput.getDuration() != null) {
                jsonGenerator.writeFieldName("Duration").writeValue(jobOutput.getDuration());
            }
            if (jobOutput.getWidth() != null) {
                jsonGenerator.writeFieldName("Width").writeValue(jobOutput.getWidth());
            }
            if (jobOutput.getHeight() != null) {
                jsonGenerator.writeFieldName("Height").writeValue(jobOutput.getHeight());
            }
            if (jobOutput.getFrameRate() != null) {
                jsonGenerator.writeFieldName("FrameRate").writeValue(jobOutput.getFrameRate());
            }
            if (jobOutput.getFileSize() != null) {
                jsonGenerator.writeFieldName("FileSize").writeValue(jobOutput.getFileSize());
            }
            if (jobOutput.getDurationMillis() != null) {
                jsonGenerator.writeFieldName("DurationMillis").writeValue(jobOutput.getDurationMillis());
            }
            if (!(watermarksList = (SdkInternalList)jobOutput.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Watermarks");
                jsonGenerator.writeStartArray();
                for (JobWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    JobWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobOutput.getAlbumArt() != null) {
                jsonGenerator.writeFieldName("AlbumArt");
                JobAlbumArtJsonMarshaller.getInstance().marshall(jobOutput.getAlbumArt(), jsonGenerator);
            }
            if (!(compositionList = (SdkInternalList)jobOutput.getComposition()).isEmpty() || !compositionList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Composition");
                jsonGenerator.writeStartArray();
                for (Clip compositionListValue : compositionList) {
                    if (compositionListValue == null) continue;
                    ClipJsonMarshaller.getInstance().marshall(compositionListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobOutput.getCaptions() != null) {
                jsonGenerator.writeFieldName("Captions");
                CaptionsJsonMarshaller.getInstance().marshall(jobOutput.getCaptions(), jsonGenerator);
            }
            if (jobOutput.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(jobOutput.getEncryption(), jsonGenerator);
            }
            if (jobOutput.getAppliedColorSpaceConversion() != null) {
                jsonGenerator.writeFieldName("AppliedColorSpaceConversion").writeValue(jobOutput.getAppliedColorSpaceConversion());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobOutputJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobOutputJsonMarshaller();
        }
        return instance;
    }
}

