/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import java.util.List;

public class ExpectedAttributeValueJsonMarshaller {
    private static ExpectedAttributeValueJsonMarshaller instance;

    public void marshall(ExpectedAttributeValue expectedAttributeValue, StructuredJsonGenerator jsonGenerator) {
        if (expectedAttributeValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeValue> attributeValueListList;
            jsonGenerator.writeStartObject();
            if (expectedAttributeValue.getValue() != null) {
                jsonGenerator.writeFieldName("Value");
                AttributeValueJsonMarshaller.getInstance().marshall(expectedAttributeValue.getValue(), jsonGenerator);
            }
            if (expectedAttributeValue.getExists() != null) {
                jsonGenerator.writeFieldName("Exists").writeValue(expectedAttributeValue.getExists());
            }
            if (expectedAttributeValue.getComparisonOperator() != null) {
                jsonGenerator.writeFieldName("ComparisonOperator").writeValue(expectedAttributeValue.getComparisonOperator());
            }
            if ((attributeValueListList = expectedAttributeValue.getAttributeValueList()) != null) {
                jsonGenerator.writeFieldName("AttributeValueList");
                jsonGenerator.writeStartArray();
                for (AttributeValue attributeValueListListValue : attributeValueListList) {
                    if (attributeValueListListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(attributeValueListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ExpectedAttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ExpectedAttributeValueJsonMarshaller();
        }
        return instance;
    }
}

