/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.ChangePasswordRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ChangePasswordRequestMarshaller
implements Marshaller<Request<ChangePasswordRequest>, ChangePasswordRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ChangePasswordRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ChangePasswordRequest> marshall(ChangePasswordRequest changePasswordRequest) {
        if (changePasswordRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ChangePasswordRequest> request = new DefaultRequest<ChangePasswordRequest>(changePasswordRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.ChangePassword");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (changePasswordRequest.getPreviousPassword() != null) {
                jsonGenerator.writeFieldName("PreviousPassword").writeValue(changePasswordRequest.getPreviousPassword());
            }
            if (changePasswordRequest.getProposedPassword() != null) {
                jsonGenerator.writeFieldName("ProposedPassword").writeValue(changePasswordRequest.getProposedPassword());
            }
            if (changePasswordRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(changePasswordRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

