/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.FacetAttributeDefinition;
import com.amazonaws.services.clouddirectory.model.Rule;
import com.amazonaws.services.clouddirectory.model.transform.RuleJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.TypedAttributeValueJsonMarshaller;
import java.util.Map;

public class FacetAttributeDefinitionJsonMarshaller {
    private static FacetAttributeDefinitionJsonMarshaller instance;

    public void marshall(FacetAttributeDefinition facetAttributeDefinition, StructuredJsonGenerator jsonGenerator) {
        if (facetAttributeDefinition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Rule> rulesMap;
            jsonGenerator.writeStartObject();
            if (facetAttributeDefinition.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(facetAttributeDefinition.getType());
            }
            if (facetAttributeDefinition.getDefaultValue() != null) {
                jsonGenerator.writeFieldName("DefaultValue");
                TypedAttributeValueJsonMarshaller.getInstance().marshall(facetAttributeDefinition.getDefaultValue(), jsonGenerator);
            }
            if (facetAttributeDefinition.getIsImmutable() != null) {
                jsonGenerator.writeFieldName("IsImmutable").writeValue(facetAttributeDefinition.getIsImmutable());
            }
            if ((rulesMap = facetAttributeDefinition.getRules()) != null) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Rule> rulesMapValue : rulesMap.entrySet()) {
                    if (rulesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(rulesMapValue.getKey());
                    RuleJsonMarshaller.getInstance().marshall(rulesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FacetAttributeDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FacetAttributeDefinitionJsonMarshaller();
        }
        return instance;
    }
}

