/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.CreateStreamingURLRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateStreamingURLRequestMarshaller
implements Marshaller<Request<CreateStreamingURLRequest>, CreateStreamingURLRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateStreamingURLRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateStreamingURLRequest> marshall(CreateStreamingURLRequest createStreamingURLRequest) {
        if (createStreamingURLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStreamingURLRequest> request = new DefaultRequest<CreateStreamingURLRequest>(createStreamingURLRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.CreateStreamingURL");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createStreamingURLRequest.getStackName() != null) {
                jsonGenerator.writeFieldName("StackName").writeValue(createStreamingURLRequest.getStackName());
            }
            if (createStreamingURLRequest.getFleetName() != null) {
                jsonGenerator.writeFieldName("FleetName").writeValue(createStreamingURLRequest.getFleetName());
            }
            if (createStreamingURLRequest.getUserId() != null) {
                jsonGenerator.writeFieldName("UserId").writeValue(createStreamingURLRequest.getUserId());
            }
            if (createStreamingURLRequest.getApplicationId() != null) {
                jsonGenerator.writeFieldName("ApplicationId").writeValue(createStreamingURLRequest.getApplicationId());
            }
            if (createStreamingURLRequest.getValidity() != null) {
                jsonGenerator.writeFieldName("Validity").writeValue(createStreamingURLRequest.getValidity());
            }
            if (createStreamingURLRequest.getSessionContext() != null) {
                jsonGenerator.writeFieldName("SessionContext").writeValue(createStreamingURLRequest.getSessionContext());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

