/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetFunctionConfigurationRequestMarshaller
implements Marshaller<Request<GetFunctionConfigurationRequest>, GetFunctionConfigurationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetFunctionConfigurationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetFunctionConfigurationRequest> marshall(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        if (getFunctionConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetFunctionConfigurationRequest> request = new DefaultRequest<GetFunctionConfigurationRequest>(getFunctionConfigurationRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/configuration";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "FunctionName", getFunctionConfigurationRequest.getFunctionName());
        request.setResourcePath(uriResourcePath);
        if (getFunctionConfigurationRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString(getFunctionConfigurationRequest.getQualifier()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

