/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EbsConfiguration
implements Serializable,
Cloneable {
    private SdkInternalList<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;
    private Boolean ebsOptimized;

    public List<EbsBlockDeviceConfig> getEbsBlockDeviceConfigs() {
        if (this.ebsBlockDeviceConfigs == null) {
            this.ebsBlockDeviceConfigs = new SdkInternalList();
        }
        return this.ebsBlockDeviceConfigs;
    }

    public void setEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
        if (ebsBlockDeviceConfigs == null) {
            this.ebsBlockDeviceConfigs = null;
            return;
        }
        this.ebsBlockDeviceConfigs = new SdkInternalList<EbsBlockDeviceConfig>(ebsBlockDeviceConfigs);
    }

    public EbsConfiguration withEbsBlockDeviceConfigs(EbsBlockDeviceConfig ... ebsBlockDeviceConfigs) {
        if (this.ebsBlockDeviceConfigs == null) {
            this.setEbsBlockDeviceConfigs(new SdkInternalList<EbsBlockDeviceConfig>(ebsBlockDeviceConfigs.length));
        }
        for (EbsBlockDeviceConfig ele : ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs.add(ele);
        }
        return this;
    }

    public EbsConfiguration withEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
        this.setEbsBlockDeviceConfigs(ebsBlockDeviceConfigs);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public EbsConfiguration withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEbsBlockDeviceConfigs() != null) {
            sb.append("EbsBlockDeviceConfigs: ").append(this.getEbsBlockDeviceConfigs()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsConfiguration)) {
            return false;
        }
        EbsConfiguration other = (EbsConfiguration)obj;
        if (other.getEbsBlockDeviceConfigs() == null ^ this.getEbsBlockDeviceConfigs() == null) {
            return false;
        }
        if (other.getEbsBlockDeviceConfigs() != null && !other.getEbsBlockDeviceConfigs().equals(this.getEbsBlockDeviceConfigs())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        return other.getEbsOptimized() == null || other.getEbsOptimized().equals(this.getEbsOptimized());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEbsBlockDeviceConfigs() == null ? 0 : this.getEbsBlockDeviceConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        return hashCode;
    }

    public EbsConfiguration clone() {
        try {
            return (EbsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

