/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.PutTraceSegmentsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class PutTraceSegmentsRequestMarshaller
implements Marshaller<Request<PutTraceSegmentsRequest>, PutTraceSegmentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutTraceSegmentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutTraceSegmentsRequest> marshall(PutTraceSegmentsRequest putTraceSegmentsRequest) {
        if (putTraceSegmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutTraceSegmentsRequest> request = new DefaultRequest<PutTraceSegmentsRequest>(putTraceSegmentsRequest, "AWSXRay");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/TraceSegments";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> traceSegmentDocumentsList = putTraceSegmentsRequest.getTraceSegmentDocuments();
            if (traceSegmentDocumentsList != null) {
                jsonGenerator.writeFieldName("TraceSegmentDocuments");
                jsonGenerator.writeStartArray();
                for (String traceSegmentDocumentsListValue : traceSegmentDocumentsList) {
                    if (traceSegmentDocumentsListValue == null) continue;
                    jsonGenerator.writeValue(traceSegmentDocumentsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

