/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListInventoryEntriesRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListInventoryEntriesRequestMarshaller
implements Marshaller<Request<ListInventoryEntriesRequest>, ListInventoryEntriesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListInventoryEntriesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListInventoryEntriesRequest> marshall(ListInventoryEntriesRequest listInventoryEntriesRequest) {
        if (listInventoryEntriesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInventoryEntriesRequest> request = new DefaultRequest<ListInventoryEntriesRequest>(listInventoryEntriesRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListInventoryEntries");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listInventoryEntriesRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(listInventoryEntriesRequest.getInstanceId());
            }
            if (listInventoryEntriesRequest.getTypeName() != null) {
                jsonGenerator.writeFieldName("TypeName").writeValue(listInventoryEntriesRequest.getTypeName());
            }
            if (!(filtersList = (SdkInternalList)listInventoryEntriesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (InventoryFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    InventoryFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (listInventoryEntriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listInventoryEntriesRequest.getNextToken());
            }
            if (listInventoryEntriesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listInventoryEntriesRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

