/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CreatePatchBaselineRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchFilterGroupJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.PatchRuleGroupJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;

public class CreatePatchBaselineRequestMarshaller
implements Marshaller<Request<CreatePatchBaselineRequest>, CreatePatchBaselineRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreatePatchBaselineRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreatePatchBaselineRequest> marshall(CreatePatchBaselineRequest createPatchBaselineRequest) {
        if (createPatchBaselineRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePatchBaselineRequest> request = new DefaultRequest<CreatePatchBaselineRequest>(createPatchBaselineRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.CreatePatchBaseline");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList rejectedPatchesList;
            SdkInternalList approvedPatchesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createPatchBaselineRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createPatchBaselineRequest.getName());
            }
            if (createPatchBaselineRequest.getGlobalFilters() != null) {
                jsonGenerator.writeFieldName("GlobalFilters");
                PatchFilterGroupJsonMarshaller.getInstance().marshall(createPatchBaselineRequest.getGlobalFilters(), jsonGenerator);
            }
            if (createPatchBaselineRequest.getApprovalRules() != null) {
                jsonGenerator.writeFieldName("ApprovalRules");
                PatchRuleGroupJsonMarshaller.getInstance().marshall(createPatchBaselineRequest.getApprovalRules(), jsonGenerator);
            }
            if (!(approvedPatchesList = (SdkInternalList)createPatchBaselineRequest.getApprovedPatches()).isEmpty() || !approvedPatchesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ApprovedPatches");
                jsonGenerator.writeStartArray();
                for (Object approvedPatchesListValue : approvedPatchesList) {
                    if (approvedPatchesListValue == null) continue;
                    jsonGenerator.writeValue((String)approvedPatchesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(rejectedPatchesList = (SdkInternalList)createPatchBaselineRequest.getRejectedPatches()).isEmpty() || !rejectedPatchesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RejectedPatches");
                jsonGenerator.writeStartArray();
                for (String rejectedPatchesListValue : rejectedPatchesList) {
                    if (rejectedPatchesListValue == null) continue;
                    jsonGenerator.writeValue(rejectedPatchesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createPatchBaselineRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createPatchBaselineRequest.getDescription());
            }
            jsonGenerator.writeFieldName("ClientToken").writeValue(IdempotentUtils.resolveString(createPatchBaselineRequest.getClientToken()));
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

