/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.EnableLoggingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class EnableLoggingRequestMarshaller
implements Marshaller<Request<EnableLoggingRequest>, EnableLoggingRequest> {
    @Override
    public Request<EnableLoggingRequest> marshall(EnableLoggingRequest enableLoggingRequest) {
        if (enableLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableLoggingRequest> request = new DefaultRequest<EnableLoggingRequest>(enableLoggingRequest, "AmazonRedshift");
        request.addParameter("Action", "EnableLogging");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableLoggingRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(enableLoggingRequest.getClusterIdentifier()));
        }
        if (enableLoggingRequest.getBucketName() != null) {
            request.addParameter("BucketName", StringUtils.fromString(enableLoggingRequest.getBucketName()));
        }
        if (enableLoggingRequest.getS3KeyPrefix() != null) {
            request.addParameter("S3KeyPrefix", StringUtils.fromString(enableLoggingRequest.getS3KeyPrefix()));
        }
        return request;
    }
}

