/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.UpdateApplicationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateApplicationRequestMarshaller
implements Marshaller<Request<UpdateApplicationRequest>, UpdateApplicationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateApplicationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateApplicationRequest> marshall(UpdateApplicationRequest updateApplicationRequest) {
        if (updateApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateApplicationRequest> request = new DefaultRequest<UpdateApplicationRequest>(updateApplicationRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.UpdateApplication");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateApplicationRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(updateApplicationRequest.getApplicationName());
            }
            if (updateApplicationRequest.getNewApplicationName() != null) {
                jsonGenerator.writeFieldName("newApplicationName").writeValue(updateApplicationRequest.getNewApplicationName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

