/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetApiKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetApiKeyRequestMarshaller
implements Marshaller<Request<GetApiKeyRequest>, GetApiKeyRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetApiKeyRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetApiKeyRequest> marshall(GetApiKeyRequest getApiKeyRequest) {
        if (getApiKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApiKeyRequest> request = new DefaultRequest<GetApiKeyRequest>(getApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/apikeys/{api_Key}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "api_Key", getApiKeyRequest.getApiKey());
        request.setResourcePath(uriResourcePath);
        if (getApiKeyRequest.getIncludeValue() != null) {
            request.addParameter("includeValue", StringUtils.fromBoolean(getApiKeyRequest.getIncludeValue()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

