/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import com.amazonaws.services.simpleworkflow.flow.core.AsyncContextBase;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncParentContext;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncStackTrace;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.util.concurrent.Executor;

class ExternalTaskContext
extends AsyncContextBase {
    private final ExternalTask task;
    private ExternalTaskCancellationHandler cancellationHandler;
    private boolean canceled;
    private boolean inCancellationHandler;
    private ExternalTaskCompletionHandleImpl completionHandle = new ExternalTaskCompletionHandleImpl();
    private String description;

    public ExternalTaskContext(ExternalTask task, Boolean daemon, Promise<?>[] waitFor) {
        super(daemon, waitFor, 6);
        this.task = task;
    }

    public ExternalTaskContext(AsyncParentContext parent, ExternalTask task, Boolean daemon, Promise<?>[] waitFor) {
        super(parent, daemon, waitFor, 6);
        this.task = task;
    }

    @Override
    public void cancel(final Throwable cause) {
        if (this.completionHandle.failure != null || this.completionHandle.completed) {
            return;
        }
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        if (this.cancellationHandler != null) {
            this.parent.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            ExternalTaskContext.this.inCancellationHandler = true;
                            ExternalTaskContext.this.cancellationHandler.handleCancellation(cause);
                        }
                        catch (Throwable e) {
                            if (ExternalTaskContext.this.stackTrace != null && !ExternalTaskContext.this.parent.isRethrown(e)) {
                                AsyncStackTrace merged = new AsyncStackTrace(ExternalTaskContext.this.stackTrace, e.getStackTrace(), 0);
                                merged.setStartFrom(ExternalTaskContext.this.getParentTaskMethodName());
                                e.setStackTrace(merged.getStackTrace());
                            }
                            ExternalTaskContext.this.completionHandle.setDoExecuteFailed("ExternalTaskCancellationHandler.handleCancellation", e);
                            ExternalTaskContext.this.inCancellationHandler = false;
                            if (ExternalTaskContext.this.completionHandle.getFailure() != null) {
                                ExternalTaskContext.this.failToParent(ExternalTaskContext.this.completionHandle.getFailure());
                            } else if (ExternalTaskContext.this.completionHandle.isCompleted()) {
                                ExternalTaskContext.this.removeFromParent();
                            }
                        }
                    }
                    finally {
                        ExternalTaskContext.this.inCancellationHandler = false;
                        if (ExternalTaskContext.this.completionHandle.getFailure() != null) {
                            ExternalTaskContext.this.failToParent(ExternalTaskContext.this.completionHandle.getFailure());
                        } else if (ExternalTaskContext.this.completionHandle.isCompleted()) {
                            ExternalTaskContext.this.removeFromParent();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void run() {
        if (this.canceled) {
            return;
        }
        ExternalTaskContext.setCurrent(this.parent);
        try {
            try {
                this.cancellationHandler = this.task.doExecute(this.completionHandle);
            }
            catch (Throwable e) {
                this.completionHandle.setDoExecuteFailed("ExternalTask.doExecute", e);
                if (this.stackTrace != null && !this.parent.isRethrown(e)) {
                    AsyncStackTrace merged = new AsyncStackTrace(this.stackTrace, e.getStackTrace(), 0);
                    merged.setStartFrom(this.getParentTaskMethodName());
                    e.setStackTrace(merged.getStackTrace());
                }
                this.parent.fail(this, e);
                ExternalTaskContext.setCurrent(null);
            }
        }
        finally {
            ExternalTaskContext.setCurrent(null);
        }
    }

    @Override
    public void add(AsyncContextBase async, Promise<?> waitFor) {
        this.parent.add(async, waitFor);
    }

    @Override
    public void remove(AsyncContextBase async) {
        this.parent.remove(async);
    }

    @Override
    public void fail(AsyncContextBase async, Throwable e) {
        this.parent.fail(async, e);
    }

    @Override
    public Executor getExecutor() {
        return this.parent.getExecutor();
    }

    @Override
    public boolean isRethrown(Throwable e) {
        return this.parent.isRethrown(e);
    }

    @Override
    public AsyncParentContext getCurrentTryCatchFinallyContext() {
        return this.parent;
    }

    @Override
    public boolean getDaemonFlagForHeir() {
        return this.isDaemon();
    }

    @Override
    public String getParentTaskMethodName() {
        if (this.canceled) {
            return "handleCancellation";
        }
        return "doExecute";
    }

    private void removeFromParent() {
        this.parent.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ExternalTaskContext.this.parent.remove(ExternalTaskContext.this);
            }
        });
    }

    private void failToParent(final Throwable e) {
        this.parent.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ExternalTaskContext.this.parent.fail(ExternalTaskContext.this, e);
            }
        });
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private final class ExternalTaskCompletionHandleImpl
    implements ExternalTaskCompletionHandle {
        private String methodName;
        private boolean completed;
        private Throwable failure;

        private ExternalTaskCompletionHandleImpl() {
        }

        private void setDoExecuteFailed(String methodName, Throwable e) {
            this.failure = e;
            this.methodName = methodName;
        }

        @Override
        public void complete() {
            if (this.failure != null) {
                throw new IllegalStateException("Invalid ExternalTaskCompletionHandle as " + this.methodName + " failed with an exception.", this.failure);
            }
            if (this.completed) {
                throw new IllegalStateException("Already completed");
            }
            this.completed = true;
            if (!ExternalTaskContext.this.inCancellationHandler) {
                ExternalTaskContext.this.removeFromParent();
            }
        }

        @Override
        public void fail(Throwable e) {
            if (this.failure != null) {
                throw new IllegalStateException("Invalid ExternalTaskCompletionHandle as " + this.methodName + " failed with exception.", this.failure);
            }
            if (this.completed) {
                throw new IllegalStateException("Already completed");
            }
            if (ExternalTaskContext.this.stackTrace != null && !ExternalTaskContext.this.parent.isRethrown(e)) {
                AsyncStackTrace merged = new AsyncStackTrace(ExternalTaskContext.this.stackTrace, e.getStackTrace(), 0);
                merged.setStartFrom(ExternalTaskContext.this.getParentTaskMethodName());
                e.setStackTrace(merged.getStackTrace());
            }
            this.failure = e;
            if (!ExternalTaskContext.this.inCancellationHandler) {
                ExternalTaskContext.this.failToParent(e);
            }
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public Throwable getFailure() {
            return this.failure;
        }
    }
}

