/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCMAsync;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCMClient;
import com.amazonaws.services.opsworkscm.model.AssociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.AssociateNodeResult;
import com.amazonaws.services.opsworkscm.model.CreateBackupRequest;
import com.amazonaws.services.opsworkscm.model.CreateBackupResult;
import com.amazonaws.services.opsworkscm.model.CreateServerRequest;
import com.amazonaws.services.opsworkscm.model.CreateServerResult;
import com.amazonaws.services.opsworkscm.model.DeleteBackupRequest;
import com.amazonaws.services.opsworkscm.model.DeleteBackupResult;
import com.amazonaws.services.opsworkscm.model.DeleteServerRequest;
import com.amazonaws.services.opsworkscm.model.DeleteServerResult;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesResult;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsResult;
import com.amazonaws.services.opsworkscm.model.DescribeEventsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeEventsResult;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusResult;
import com.amazonaws.services.opsworkscm.model.DescribeServersRequest;
import com.amazonaws.services.opsworkscm.model.DescribeServersResult;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeResult;
import com.amazonaws.services.opsworkscm.model.RestoreServerRequest;
import com.amazonaws.services.opsworkscm.model.RestoreServerResult;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceRequest;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOpsWorksCMAsyncClient
extends AWSOpsWorksCMClient
implements AWSOpsWorksCMAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSOpsWorksCMAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSOpsWorksCMAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSOpsWorksCMAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateNodeResult> associateNodeAsync(AssociateNodeRequest request) {
        return this.associateNodeAsync(request, null);
    }

    @Override
    public Future<AssociateNodeResult> associateNodeAsync(final AssociateNodeRequest request, final AsyncHandler<AssociateNodeRequest, AssociateNodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssociateNodeResult>(){

            @Override
            public AssociateNodeResult call() throws Exception {
                AssociateNodeResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.associateNode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupAsync(request, null);
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(final CreateBackupRequest request, final AsyncHandler<CreateBackupRequest, CreateBackupResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                CreateBackupResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.createBackup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateServerResult> createServerAsync(CreateServerRequest request) {
        return this.createServerAsync(request, null);
    }

    @Override
    public Future<CreateServerResult> createServerAsync(final CreateServerRequest request, final AsyncHandler<CreateServerRequest, CreateServerResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateServerResult>(){

            @Override
            public CreateServerResult call() throws Exception {
                CreateServerResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.createServer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupAsync(request, null);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(final DeleteBackupRequest request, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.deleteBackup(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteServerResult> deleteServerAsync(DeleteServerRequest request) {
        return this.deleteServerAsync(request, null);
    }

    @Override
    public Future<DeleteServerResult> deleteServerAsync(final DeleteServerRequest request, final AsyncHandler<DeleteServerRequest, DeleteServerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteServerResult>(){

            @Override
            public DeleteServerResult call() throws Exception {
                DeleteServerResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.deleteServer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(DescribeAccountAttributesRequest request) {
        return this.describeAccountAttributesAsync(request, null);
    }

    @Override
    public Future<DescribeAccountAttributesResult> describeAccountAttributesAsync(final DescribeAccountAttributesRequest request, final AsyncHandler<DescribeAccountAttributesRequest, DescribeAccountAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAccountAttributesResult>(){

            @Override
            public DescribeAccountAttributesResult call() throws Exception {
                DescribeAccountAttributesResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.describeAccountAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request) {
        return this.describeBackupsAsync(request, null);
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(final DescribeBackupsRequest request, final AsyncHandler<DescribeBackupsRequest, DescribeBackupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeBackupsResult>(){

            @Override
            public DescribeBackupsResult call() throws Exception {
                DescribeBackupsResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.describeBackups(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.describeEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeNodeAssociationStatusResult> describeNodeAssociationStatusAsync(DescribeNodeAssociationStatusRequest request) {
        return this.describeNodeAssociationStatusAsync(request, null);
    }

    @Override
    public Future<DescribeNodeAssociationStatusResult> describeNodeAssociationStatusAsync(final DescribeNodeAssociationStatusRequest request, final AsyncHandler<DescribeNodeAssociationStatusRequest, DescribeNodeAssociationStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeNodeAssociationStatusResult>(){

            @Override
            public DescribeNodeAssociationStatusResult call() throws Exception {
                DescribeNodeAssociationStatusResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.describeNodeAssociationStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeServersResult> describeServersAsync(DescribeServersRequest request) {
        return this.describeServersAsync(request, null);
    }

    @Override
    public Future<DescribeServersResult> describeServersAsync(final DescribeServersRequest request, final AsyncHandler<DescribeServersRequest, DescribeServersResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeServersResult>(){

            @Override
            public DescribeServersResult call() throws Exception {
                DescribeServersResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.describeServers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateNodeResult> disassociateNodeAsync(DisassociateNodeRequest request) {
        return this.disassociateNodeAsync(request, null);
    }

    @Override
    public Future<DisassociateNodeResult> disassociateNodeAsync(final DisassociateNodeRequest request, final AsyncHandler<DisassociateNodeRequest, DisassociateNodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisassociateNodeResult>(){

            @Override
            public DisassociateNodeResult call() throws Exception {
                DisassociateNodeResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.disassociateNode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreServerResult> restoreServerAsync(RestoreServerRequest request) {
        return this.restoreServerAsync(request, null);
    }

    @Override
    public Future<RestoreServerResult> restoreServerAsync(final RestoreServerRequest request, final AsyncHandler<RestoreServerRequest, RestoreServerResult> asyncHandler) {
        return this.executorService.submit(new Callable<RestoreServerResult>(){

            @Override
            public RestoreServerResult call() throws Exception {
                RestoreServerResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.restoreServer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMaintenanceResult> startMaintenanceAsync(StartMaintenanceRequest request) {
        return this.startMaintenanceAsync(request, null);
    }

    @Override
    public Future<StartMaintenanceResult> startMaintenanceAsync(final StartMaintenanceRequest request, final AsyncHandler<StartMaintenanceRequest, StartMaintenanceResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartMaintenanceResult>(){

            @Override
            public StartMaintenanceResult call() throws Exception {
                StartMaintenanceResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.startMaintenance(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServerResult> updateServerAsync(UpdateServerRequest request) {
        return this.updateServerAsync(request, null);
    }

    @Override
    public Future<UpdateServerResult> updateServerAsync(final UpdateServerRequest request, final AsyncHandler<UpdateServerRequest, UpdateServerResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateServerResult>(){

            @Override
            public UpdateServerResult call() throws Exception {
                UpdateServerResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.updateServer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateServerEngineAttributesResult> updateServerEngineAttributesAsync(UpdateServerEngineAttributesRequest request) {
        return this.updateServerEngineAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateServerEngineAttributesResult> updateServerEngineAttributesAsync(final UpdateServerEngineAttributesRequest request, final AsyncHandler<UpdateServerEngineAttributesRequest, UpdateServerEngineAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateServerEngineAttributesResult>(){

            @Override
            public UpdateServerEngineAttributesResult call() throws Exception {
                UpdateServerEngineAttributesResult result;
                try {
                    result = AWSOpsWorksCMAsyncClient.this.updateServerEngineAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

