/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ArtifactRevision;
import com.amazonaws.services.codepipeline.model.PipelineExecution;
import com.amazonaws.services.codepipeline.model.transform.ArtifactRevisionJsonMarshaller;
import java.util.List;

public class PipelineExecutionJsonMarshaller {
    private static PipelineExecutionJsonMarshaller instance;

    public void marshall(PipelineExecution pipelineExecution, StructuredJsonGenerator jsonGenerator) {
        if (pipelineExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ArtifactRevision> artifactRevisionsList;
            jsonGenerator.writeStartObject();
            if (pipelineExecution.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(pipelineExecution.getPipelineName());
            }
            if (pipelineExecution.getPipelineVersion() != null) {
                jsonGenerator.writeFieldName("pipelineVersion").writeValue(pipelineExecution.getPipelineVersion());
            }
            if (pipelineExecution.getPipelineExecutionId() != null) {
                jsonGenerator.writeFieldName("pipelineExecutionId").writeValue(pipelineExecution.getPipelineExecutionId());
            }
            if (pipelineExecution.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(pipelineExecution.getStatus());
            }
            if ((artifactRevisionsList = pipelineExecution.getArtifactRevisions()) != null) {
                jsonGenerator.writeFieldName("artifactRevisions");
                jsonGenerator.writeStartArray();
                for (ArtifactRevision artifactRevisionsListValue : artifactRevisionsList) {
                    if (artifactRevisionsListValue == null) continue;
                    ArtifactRevisionJsonMarshaller.getInstance().marshall(artifactRevisionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineExecutionJsonMarshaller();
        }
        return instance;
    }
}

