/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.clouddirectory.AmazonCloudDirectoryAsync;
import com.amazonaws.services.clouddirectory.AmazonCloudDirectoryClient;
import com.amazonaws.services.clouddirectory.model.AddFacetToObjectRequest;
import com.amazonaws.services.clouddirectory.model.AddFacetToObjectResult;
import com.amazonaws.services.clouddirectory.model.ApplySchemaRequest;
import com.amazonaws.services.clouddirectory.model.ApplySchemaResult;
import com.amazonaws.services.clouddirectory.model.AttachObjectRequest;
import com.amazonaws.services.clouddirectory.model.AttachObjectResult;
import com.amazonaws.services.clouddirectory.model.AttachPolicyRequest;
import com.amazonaws.services.clouddirectory.model.AttachPolicyResult;
import com.amazonaws.services.clouddirectory.model.AttachToIndexRequest;
import com.amazonaws.services.clouddirectory.model.AttachToIndexResult;
import com.amazonaws.services.clouddirectory.model.BatchReadRequest;
import com.amazonaws.services.clouddirectory.model.BatchReadResult;
import com.amazonaws.services.clouddirectory.model.BatchWriteRequest;
import com.amazonaws.services.clouddirectory.model.BatchWriteResult;
import com.amazonaws.services.clouddirectory.model.CreateDirectoryRequest;
import com.amazonaws.services.clouddirectory.model.CreateDirectoryResult;
import com.amazonaws.services.clouddirectory.model.CreateFacetRequest;
import com.amazonaws.services.clouddirectory.model.CreateFacetResult;
import com.amazonaws.services.clouddirectory.model.CreateIndexRequest;
import com.amazonaws.services.clouddirectory.model.CreateIndexResult;
import com.amazonaws.services.clouddirectory.model.CreateObjectRequest;
import com.amazonaws.services.clouddirectory.model.CreateObjectResult;
import com.amazonaws.services.clouddirectory.model.CreateSchemaRequest;
import com.amazonaws.services.clouddirectory.model.CreateSchemaResult;
import com.amazonaws.services.clouddirectory.model.DeleteDirectoryRequest;
import com.amazonaws.services.clouddirectory.model.DeleteDirectoryResult;
import com.amazonaws.services.clouddirectory.model.DeleteFacetRequest;
import com.amazonaws.services.clouddirectory.model.DeleteFacetResult;
import com.amazonaws.services.clouddirectory.model.DeleteObjectRequest;
import com.amazonaws.services.clouddirectory.model.DeleteObjectResult;
import com.amazonaws.services.clouddirectory.model.DeleteSchemaRequest;
import com.amazonaws.services.clouddirectory.model.DeleteSchemaResult;
import com.amazonaws.services.clouddirectory.model.DetachFromIndexRequest;
import com.amazonaws.services.clouddirectory.model.DetachFromIndexResult;
import com.amazonaws.services.clouddirectory.model.DetachObjectRequest;
import com.amazonaws.services.clouddirectory.model.DetachObjectResult;
import com.amazonaws.services.clouddirectory.model.DetachPolicyRequest;
import com.amazonaws.services.clouddirectory.model.DetachPolicyResult;
import com.amazonaws.services.clouddirectory.model.DisableDirectoryRequest;
import com.amazonaws.services.clouddirectory.model.DisableDirectoryResult;
import com.amazonaws.services.clouddirectory.model.EnableDirectoryRequest;
import com.amazonaws.services.clouddirectory.model.EnableDirectoryResult;
import com.amazonaws.services.clouddirectory.model.GetDirectoryRequest;
import com.amazonaws.services.clouddirectory.model.GetDirectoryResult;
import com.amazonaws.services.clouddirectory.model.GetFacetRequest;
import com.amazonaws.services.clouddirectory.model.GetFacetResult;
import com.amazonaws.services.clouddirectory.model.GetObjectInformationRequest;
import com.amazonaws.services.clouddirectory.model.GetObjectInformationResult;
import com.amazonaws.services.clouddirectory.model.GetSchemaAsJsonRequest;
import com.amazonaws.services.clouddirectory.model.GetSchemaAsJsonResult;
import com.amazonaws.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import com.amazonaws.services.clouddirectory.model.ListAppliedSchemaArnsResult;
import com.amazonaws.services.clouddirectory.model.ListAttachedIndicesRequest;
import com.amazonaws.services.clouddirectory.model.ListAttachedIndicesResult;
import com.amazonaws.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import com.amazonaws.services.clouddirectory.model.ListDevelopmentSchemaArnsResult;
import com.amazonaws.services.clouddirectory.model.ListDirectoriesRequest;
import com.amazonaws.services.clouddirectory.model.ListDirectoriesResult;
import com.amazonaws.services.clouddirectory.model.ListFacetAttributesRequest;
import com.amazonaws.services.clouddirectory.model.ListFacetAttributesResult;
import com.amazonaws.services.clouddirectory.model.ListFacetNamesRequest;
import com.amazonaws.services.clouddirectory.model.ListFacetNamesResult;
import com.amazonaws.services.clouddirectory.model.ListIndexRequest;
import com.amazonaws.services.clouddirectory.model.ListIndexResult;
import com.amazonaws.services.clouddirectory.model.ListObjectAttributesRequest;
import com.amazonaws.services.clouddirectory.model.ListObjectAttributesResult;
import com.amazonaws.services.clouddirectory.model.ListObjectChildrenRequest;
import com.amazonaws.services.clouddirectory.model.ListObjectChildrenResult;
import com.amazonaws.services.clouddirectory.model.ListObjectParentsRequest;
import com.amazonaws.services.clouddirectory.model.ListObjectParentsResult;
import com.amazonaws.services.clouddirectory.model.ListObjectPoliciesRequest;
import com.amazonaws.services.clouddirectory.model.ListObjectPoliciesResult;
import com.amazonaws.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import com.amazonaws.services.clouddirectory.model.ListPolicyAttachmentsResult;
import com.amazonaws.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import com.amazonaws.services.clouddirectory.model.ListPublishedSchemaArnsResult;
import com.amazonaws.services.clouddirectory.model.ListTagsForResourceRequest;
import com.amazonaws.services.clouddirectory.model.ListTagsForResourceResult;
import com.amazonaws.services.clouddirectory.model.LookupPolicyRequest;
import com.amazonaws.services.clouddirectory.model.LookupPolicyResult;
import com.amazonaws.services.clouddirectory.model.PublishSchemaRequest;
import com.amazonaws.services.clouddirectory.model.PublishSchemaResult;
import com.amazonaws.services.clouddirectory.model.PutSchemaFromJsonRequest;
import com.amazonaws.services.clouddirectory.model.PutSchemaFromJsonResult;
import com.amazonaws.services.clouddirectory.model.RemoveFacetFromObjectRequest;
import com.amazonaws.services.clouddirectory.model.RemoveFacetFromObjectResult;
import com.amazonaws.services.clouddirectory.model.TagResourceRequest;
import com.amazonaws.services.clouddirectory.model.TagResourceResult;
import com.amazonaws.services.clouddirectory.model.UntagResourceRequest;
import com.amazonaws.services.clouddirectory.model.UntagResourceResult;
import com.amazonaws.services.clouddirectory.model.UpdateFacetRequest;
import com.amazonaws.services.clouddirectory.model.UpdateFacetResult;
import com.amazonaws.services.clouddirectory.model.UpdateObjectAttributesRequest;
import com.amazonaws.services.clouddirectory.model.UpdateObjectAttributesResult;
import com.amazonaws.services.clouddirectory.model.UpdateSchemaRequest;
import com.amazonaws.services.clouddirectory.model.UpdateSchemaResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudDirectoryAsyncClient
extends AmazonCloudDirectoryClient
implements AmazonCloudDirectoryAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudDirectoryAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudDirectoryAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonCloudDirectoryAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddFacetToObjectResult> addFacetToObjectAsync(AddFacetToObjectRequest request) {
        return this.addFacetToObjectAsync(request, null);
    }

    @Override
    public Future<AddFacetToObjectResult> addFacetToObjectAsync(final AddFacetToObjectRequest request, final AsyncHandler<AddFacetToObjectRequest, AddFacetToObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddFacetToObjectResult>(){

            @Override
            public AddFacetToObjectResult call() throws Exception {
                AddFacetToObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.addFacetToObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ApplySchemaResult> applySchemaAsync(ApplySchemaRequest request) {
        return this.applySchemaAsync(request, null);
    }

    @Override
    public Future<ApplySchemaResult> applySchemaAsync(final ApplySchemaRequest request, final AsyncHandler<ApplySchemaRequest, ApplySchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<ApplySchemaResult>(){

            @Override
            public ApplySchemaResult call() throws Exception {
                ApplySchemaResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.applySchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachObjectResult> attachObjectAsync(AttachObjectRequest request) {
        return this.attachObjectAsync(request, null);
    }

    @Override
    public Future<AttachObjectResult> attachObjectAsync(final AttachObjectRequest request, final AsyncHandler<AttachObjectRequest, AttachObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachObjectResult>(){

            @Override
            public AttachObjectResult call() throws Exception {
                AttachObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.attachObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachPolicyResult> attachPolicyAsync(AttachPolicyRequest request) {
        return this.attachPolicyAsync(request, null);
    }

    @Override
    public Future<AttachPolicyResult> attachPolicyAsync(final AttachPolicyRequest request, final AsyncHandler<AttachPolicyRequest, AttachPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachPolicyResult>(){

            @Override
            public AttachPolicyResult call() throws Exception {
                AttachPolicyResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.attachPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachToIndexResult> attachToIndexAsync(AttachToIndexRequest request) {
        return this.attachToIndexAsync(request, null);
    }

    @Override
    public Future<AttachToIndexResult> attachToIndexAsync(final AttachToIndexRequest request, final AsyncHandler<AttachToIndexRequest, AttachToIndexResult> asyncHandler) {
        return this.executorService.submit(new Callable<AttachToIndexResult>(){

            @Override
            public AttachToIndexResult call() throws Exception {
                AttachToIndexResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.attachToIndex(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchReadResult> batchReadAsync(BatchReadRequest request) {
        return this.batchReadAsync(request, null);
    }

    @Override
    public Future<BatchReadResult> batchReadAsync(final BatchReadRequest request, final AsyncHandler<BatchReadRequest, BatchReadResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchReadResult>(){

            @Override
            public BatchReadResult call() throws Exception {
                BatchReadResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.batchRead(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchWriteResult> batchWriteAsync(BatchWriteRequest request) {
        return this.batchWriteAsync(request, null);
    }

    @Override
    public Future<BatchWriteResult> batchWriteAsync(final BatchWriteRequest request, final AsyncHandler<BatchWriteRequest, BatchWriteResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchWriteResult>(){

            @Override
            public BatchWriteResult call() throws Exception {
                BatchWriteResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.batchWrite(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(CreateDirectoryRequest request) {
        return this.createDirectoryAsync(request, null);
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(final CreateDirectoryRequest request, final AsyncHandler<CreateDirectoryRequest, CreateDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateDirectoryResult>(){

            @Override
            public CreateDirectoryResult call() throws Exception {
                CreateDirectoryResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.createDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFacetResult> createFacetAsync(CreateFacetRequest request) {
        return this.createFacetAsync(request, null);
    }

    @Override
    public Future<CreateFacetResult> createFacetAsync(final CreateFacetRequest request, final AsyncHandler<CreateFacetRequest, CreateFacetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateFacetResult>(){

            @Override
            public CreateFacetResult call() throws Exception {
                CreateFacetResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.createFacet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateIndexResult> createIndexAsync(CreateIndexRequest request) {
        return this.createIndexAsync(request, null);
    }

    @Override
    public Future<CreateIndexResult> createIndexAsync(final CreateIndexRequest request, final AsyncHandler<CreateIndexRequest, CreateIndexResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateIndexResult>(){

            @Override
            public CreateIndexResult call() throws Exception {
                CreateIndexResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.createIndex(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateObjectResult> createObjectAsync(CreateObjectRequest request) {
        return this.createObjectAsync(request, null);
    }

    @Override
    public Future<CreateObjectResult> createObjectAsync(final CreateObjectRequest request, final AsyncHandler<CreateObjectRequest, CreateObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateObjectResult>(){

            @Override
            public CreateObjectResult call() throws Exception {
                CreateObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.createObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSchemaResult> createSchemaAsync(CreateSchemaRequest request) {
        return this.createSchemaAsync(request, null);
    }

    @Override
    public Future<CreateSchemaResult> createSchemaAsync(final CreateSchemaRequest request, final AsyncHandler<CreateSchemaRequest, CreateSchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSchemaResult>(){

            @Override
            public CreateSchemaResult call() throws Exception {
                CreateSchemaResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.createSchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(DeleteDirectoryRequest request) {
        return this.deleteDirectoryAsync(request, null);
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(final DeleteDirectoryRequest request, final AsyncHandler<DeleteDirectoryRequest, DeleteDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteDirectoryResult>(){

            @Override
            public DeleteDirectoryResult call() throws Exception {
                DeleteDirectoryResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.deleteDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFacetResult> deleteFacetAsync(DeleteFacetRequest request) {
        return this.deleteFacetAsync(request, null);
    }

    @Override
    public Future<DeleteFacetResult> deleteFacetAsync(final DeleteFacetRequest request, final AsyncHandler<DeleteFacetRequest, DeleteFacetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteFacetResult>(){

            @Override
            public DeleteFacetResult call() throws Exception {
                DeleteFacetResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.deleteFacet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(DeleteObjectRequest request) {
        return this.deleteObjectAsync(request, null);
    }

    @Override
    public Future<DeleteObjectResult> deleteObjectAsync(final DeleteObjectRequest request, final AsyncHandler<DeleteObjectRequest, DeleteObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult call() throws Exception {
                DeleteObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.deleteObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSchemaResult> deleteSchemaAsync(DeleteSchemaRequest request) {
        return this.deleteSchemaAsync(request, null);
    }

    @Override
    public Future<DeleteSchemaResult> deleteSchemaAsync(final DeleteSchemaRequest request, final AsyncHandler<DeleteSchemaRequest, DeleteSchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSchemaResult>(){

            @Override
            public DeleteSchemaResult call() throws Exception {
                DeleteSchemaResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.deleteSchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachFromIndexResult> detachFromIndexAsync(DetachFromIndexRequest request) {
        return this.detachFromIndexAsync(request, null);
    }

    @Override
    public Future<DetachFromIndexResult> detachFromIndexAsync(final DetachFromIndexRequest request, final AsyncHandler<DetachFromIndexRequest, DetachFromIndexResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachFromIndexResult>(){

            @Override
            public DetachFromIndexResult call() throws Exception {
                DetachFromIndexResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.detachFromIndex(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachObjectResult> detachObjectAsync(DetachObjectRequest request) {
        return this.detachObjectAsync(request, null);
    }

    @Override
    public Future<DetachObjectResult> detachObjectAsync(final DetachObjectRequest request, final AsyncHandler<DetachObjectRequest, DetachObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachObjectResult>(){

            @Override
            public DetachObjectResult call() throws Exception {
                DetachObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.detachObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachPolicyResult> detachPolicyAsync(DetachPolicyRequest request) {
        return this.detachPolicyAsync(request, null);
    }

    @Override
    public Future<DetachPolicyResult> detachPolicyAsync(final DetachPolicyRequest request, final AsyncHandler<DetachPolicyRequest, DetachPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DetachPolicyResult>(){

            @Override
            public DetachPolicyResult call() throws Exception {
                DetachPolicyResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.detachPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableDirectoryResult> disableDirectoryAsync(DisableDirectoryRequest request) {
        return this.disableDirectoryAsync(request, null);
    }

    @Override
    public Future<DisableDirectoryResult> disableDirectoryAsync(final DisableDirectoryRequest request, final AsyncHandler<DisableDirectoryRequest, DisableDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableDirectoryResult>(){

            @Override
            public DisableDirectoryResult call() throws Exception {
                DisableDirectoryResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.disableDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableDirectoryResult> enableDirectoryAsync(EnableDirectoryRequest request) {
        return this.enableDirectoryAsync(request, null);
    }

    @Override
    public Future<EnableDirectoryResult> enableDirectoryAsync(final EnableDirectoryRequest request, final AsyncHandler<EnableDirectoryRequest, EnableDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableDirectoryResult>(){

            @Override
            public EnableDirectoryResult call() throws Exception {
                EnableDirectoryResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.enableDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryResult> getDirectoryAsync(GetDirectoryRequest request) {
        return this.getDirectoryAsync(request, null);
    }

    @Override
    public Future<GetDirectoryResult> getDirectoryAsync(final GetDirectoryRequest request, final AsyncHandler<GetDirectoryRequest, GetDirectoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDirectoryResult>(){

            @Override
            public GetDirectoryResult call() throws Exception {
                GetDirectoryResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.getDirectory(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFacetResult> getFacetAsync(GetFacetRequest request) {
        return this.getFacetAsync(request, null);
    }

    @Override
    public Future<GetFacetResult> getFacetAsync(final GetFacetRequest request, final AsyncHandler<GetFacetRequest, GetFacetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetFacetResult>(){

            @Override
            public GetFacetResult call() throws Exception {
                GetFacetResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.getFacet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetObjectInformationResult> getObjectInformationAsync(GetObjectInformationRequest request) {
        return this.getObjectInformationAsync(request, null);
    }

    @Override
    public Future<GetObjectInformationResult> getObjectInformationAsync(final GetObjectInformationRequest request, final AsyncHandler<GetObjectInformationRequest, GetObjectInformationResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetObjectInformationResult>(){

            @Override
            public GetObjectInformationResult call() throws Exception {
                GetObjectInformationResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.getObjectInformation(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSchemaAsJsonResult> getSchemaAsJsonAsync(GetSchemaAsJsonRequest request) {
        return this.getSchemaAsJsonAsync(request, null);
    }

    @Override
    public Future<GetSchemaAsJsonResult> getSchemaAsJsonAsync(final GetSchemaAsJsonRequest request, final AsyncHandler<GetSchemaAsJsonRequest, GetSchemaAsJsonResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSchemaAsJsonResult>(){

            @Override
            public GetSchemaAsJsonResult call() throws Exception {
                GetSchemaAsJsonResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.getSchemaAsJson(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAppliedSchemaArnsResult> listAppliedSchemaArnsAsync(ListAppliedSchemaArnsRequest request) {
        return this.listAppliedSchemaArnsAsync(request, null);
    }

    @Override
    public Future<ListAppliedSchemaArnsResult> listAppliedSchemaArnsAsync(final ListAppliedSchemaArnsRequest request, final AsyncHandler<ListAppliedSchemaArnsRequest, ListAppliedSchemaArnsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAppliedSchemaArnsResult>(){

            @Override
            public ListAppliedSchemaArnsResult call() throws Exception {
                ListAppliedSchemaArnsResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listAppliedSchemaArns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAttachedIndicesResult> listAttachedIndicesAsync(ListAttachedIndicesRequest request) {
        return this.listAttachedIndicesAsync(request, null);
    }

    @Override
    public Future<ListAttachedIndicesResult> listAttachedIndicesAsync(final ListAttachedIndicesRequest request, final AsyncHandler<ListAttachedIndicesRequest, ListAttachedIndicesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListAttachedIndicesResult>(){

            @Override
            public ListAttachedIndicesResult call() throws Exception {
                ListAttachedIndicesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listAttachedIndices(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDevelopmentSchemaArnsResult> listDevelopmentSchemaArnsAsync(ListDevelopmentSchemaArnsRequest request) {
        return this.listDevelopmentSchemaArnsAsync(request, null);
    }

    @Override
    public Future<ListDevelopmentSchemaArnsResult> listDevelopmentSchemaArnsAsync(final ListDevelopmentSchemaArnsRequest request, final AsyncHandler<ListDevelopmentSchemaArnsRequest, ListDevelopmentSchemaArnsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDevelopmentSchemaArnsResult>(){

            @Override
            public ListDevelopmentSchemaArnsResult call() throws Exception {
                ListDevelopmentSchemaArnsResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listDevelopmentSchemaArns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDirectoriesResult> listDirectoriesAsync(ListDirectoriesRequest request) {
        return this.listDirectoriesAsync(request, null);
    }

    @Override
    public Future<ListDirectoriesResult> listDirectoriesAsync(final ListDirectoriesRequest request, final AsyncHandler<ListDirectoriesRequest, ListDirectoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListDirectoriesResult>(){

            @Override
            public ListDirectoriesResult call() throws Exception {
                ListDirectoriesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listDirectories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFacetAttributesResult> listFacetAttributesAsync(ListFacetAttributesRequest request) {
        return this.listFacetAttributesAsync(request, null);
    }

    @Override
    public Future<ListFacetAttributesResult> listFacetAttributesAsync(final ListFacetAttributesRequest request, final AsyncHandler<ListFacetAttributesRequest, ListFacetAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFacetAttributesResult>(){

            @Override
            public ListFacetAttributesResult call() throws Exception {
                ListFacetAttributesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listFacetAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFacetNamesResult> listFacetNamesAsync(ListFacetNamesRequest request) {
        return this.listFacetNamesAsync(request, null);
    }

    @Override
    public Future<ListFacetNamesResult> listFacetNamesAsync(final ListFacetNamesRequest request, final AsyncHandler<ListFacetNamesRequest, ListFacetNamesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListFacetNamesResult>(){

            @Override
            public ListFacetNamesResult call() throws Exception {
                ListFacetNamesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listFacetNames(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIndexResult> listIndexAsync(ListIndexRequest request) {
        return this.listIndexAsync(request, null);
    }

    @Override
    public Future<ListIndexResult> listIndexAsync(final ListIndexRequest request, final AsyncHandler<ListIndexRequest, ListIndexResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListIndexResult>(){

            @Override
            public ListIndexResult call() throws Exception {
                ListIndexResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listIndex(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectAttributesResult> listObjectAttributesAsync(ListObjectAttributesRequest request) {
        return this.listObjectAttributesAsync(request, null);
    }

    @Override
    public Future<ListObjectAttributesResult> listObjectAttributesAsync(final ListObjectAttributesRequest request, final AsyncHandler<ListObjectAttributesRequest, ListObjectAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListObjectAttributesResult>(){

            @Override
            public ListObjectAttributesResult call() throws Exception {
                ListObjectAttributesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listObjectAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectChildrenResult> listObjectChildrenAsync(ListObjectChildrenRequest request) {
        return this.listObjectChildrenAsync(request, null);
    }

    @Override
    public Future<ListObjectChildrenResult> listObjectChildrenAsync(final ListObjectChildrenRequest request, final AsyncHandler<ListObjectChildrenRequest, ListObjectChildrenResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListObjectChildrenResult>(){

            @Override
            public ListObjectChildrenResult call() throws Exception {
                ListObjectChildrenResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listObjectChildren(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectParentsResult> listObjectParentsAsync(ListObjectParentsRequest request) {
        return this.listObjectParentsAsync(request, null);
    }

    @Override
    public Future<ListObjectParentsResult> listObjectParentsAsync(final ListObjectParentsRequest request, final AsyncHandler<ListObjectParentsRequest, ListObjectParentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListObjectParentsResult>(){

            @Override
            public ListObjectParentsResult call() throws Exception {
                ListObjectParentsResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listObjectParents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectPoliciesResult> listObjectPoliciesAsync(ListObjectPoliciesRequest request) {
        return this.listObjectPoliciesAsync(request, null);
    }

    @Override
    public Future<ListObjectPoliciesResult> listObjectPoliciesAsync(final ListObjectPoliciesRequest request, final AsyncHandler<ListObjectPoliciesRequest, ListObjectPoliciesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListObjectPoliciesResult>(){

            @Override
            public ListObjectPoliciesResult call() throws Exception {
                ListObjectPoliciesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listObjectPolicies(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPolicyAttachmentsResult> listPolicyAttachmentsAsync(ListPolicyAttachmentsRequest request) {
        return this.listPolicyAttachmentsAsync(request, null);
    }

    @Override
    public Future<ListPolicyAttachmentsResult> listPolicyAttachmentsAsync(final ListPolicyAttachmentsRequest request, final AsyncHandler<ListPolicyAttachmentsRequest, ListPolicyAttachmentsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPolicyAttachmentsResult>(){

            @Override
            public ListPolicyAttachmentsResult call() throws Exception {
                ListPolicyAttachmentsResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listPolicyAttachments(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPublishedSchemaArnsResult> listPublishedSchemaArnsAsync(ListPublishedSchemaArnsRequest request) {
        return this.listPublishedSchemaArnsAsync(request, null);
    }

    @Override
    public Future<ListPublishedSchemaArnsResult> listPublishedSchemaArnsAsync(final ListPublishedSchemaArnsRequest request, final AsyncHandler<ListPublishedSchemaArnsRequest, ListPublishedSchemaArnsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPublishedSchemaArnsResult>(){

            @Override
            public ListPublishedSchemaArnsResult call() throws Exception {
                ListPublishedSchemaArnsResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listPublishedSchemaArns(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.listTagsForResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LookupPolicyResult> lookupPolicyAsync(LookupPolicyRequest request) {
        return this.lookupPolicyAsync(request, null);
    }

    @Override
    public Future<LookupPolicyResult> lookupPolicyAsync(final LookupPolicyRequest request, final AsyncHandler<LookupPolicyRequest, LookupPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<LookupPolicyResult>(){

            @Override
            public LookupPolicyResult call() throws Exception {
                LookupPolicyResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.lookupPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishSchemaResult> publishSchemaAsync(PublishSchemaRequest request) {
        return this.publishSchemaAsync(request, null);
    }

    @Override
    public Future<PublishSchemaResult> publishSchemaAsync(final PublishSchemaRequest request, final AsyncHandler<PublishSchemaRequest, PublishSchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<PublishSchemaResult>(){

            @Override
            public PublishSchemaResult call() throws Exception {
                PublishSchemaResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.publishSchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSchemaFromJsonResult> putSchemaFromJsonAsync(PutSchemaFromJsonRequest request) {
        return this.putSchemaFromJsonAsync(request, null);
    }

    @Override
    public Future<PutSchemaFromJsonResult> putSchemaFromJsonAsync(final PutSchemaFromJsonRequest request, final AsyncHandler<PutSchemaFromJsonRequest, PutSchemaFromJsonResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutSchemaFromJsonResult>(){

            @Override
            public PutSchemaFromJsonResult call() throws Exception {
                PutSchemaFromJsonResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.putSchemaFromJson(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveFacetFromObjectResult> removeFacetFromObjectAsync(RemoveFacetFromObjectRequest request) {
        return this.removeFacetFromObjectAsync(request, null);
    }

    @Override
    public Future<RemoveFacetFromObjectResult> removeFacetFromObjectAsync(final RemoveFacetFromObjectRequest request, final AsyncHandler<RemoveFacetFromObjectRequest, RemoveFacetFromObjectResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveFacetFromObjectResult>(){

            @Override
            public RemoveFacetFromObjectResult call() throws Exception {
                RemoveFacetFromObjectResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.removeFacetFromObject(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(final TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.tagResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(final UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.untagResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFacetResult> updateFacetAsync(UpdateFacetRequest request) {
        return this.updateFacetAsync(request, null);
    }

    @Override
    public Future<UpdateFacetResult> updateFacetAsync(final UpdateFacetRequest request, final AsyncHandler<UpdateFacetRequest, UpdateFacetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateFacetResult>(){

            @Override
            public UpdateFacetResult call() throws Exception {
                UpdateFacetResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.updateFacet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateObjectAttributesResult> updateObjectAttributesAsync(UpdateObjectAttributesRequest request) {
        return this.updateObjectAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateObjectAttributesResult> updateObjectAttributesAsync(final UpdateObjectAttributesRequest request, final AsyncHandler<UpdateObjectAttributesRequest, UpdateObjectAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateObjectAttributesResult>(){

            @Override
            public UpdateObjectAttributesResult call() throws Exception {
                UpdateObjectAttributesResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.updateObjectAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSchemaResult> updateSchemaAsync(UpdateSchemaRequest request) {
        return this.updateSchemaAsync(request, null);
    }

    @Override
    public Future<UpdateSchemaResult> updateSchemaAsync(final UpdateSchemaRequest request, final AsyncHandler<UpdateSchemaRequest, UpdateSchemaResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateSchemaResult>(){

            @Override
            public UpdateSchemaResult call() throws Exception {
                UpdateSchemaResult result;
                try {
                    result = AmazonCloudDirectoryAsyncClient.this.updateSchema(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

