/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.ListServerNeighborsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListServerNeighborsRequestMarshaller
implements Marshaller<Request<ListServerNeighborsRequest>, ListServerNeighborsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListServerNeighborsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListServerNeighborsRequest> marshall(ListServerNeighborsRequest listServerNeighborsRequest) {
        if (listServerNeighborsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListServerNeighborsRequest> request = new DefaultRequest<ListServerNeighborsRequest>(listServerNeighborsRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.ListServerNeighbors");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> neighborConfigurationIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listServerNeighborsRequest.getConfigurationId() != null) {
                jsonGenerator.writeFieldName("configurationId").writeValue(listServerNeighborsRequest.getConfigurationId());
            }
            if (listServerNeighborsRequest.getPortInformationNeeded() != null) {
                jsonGenerator.writeFieldName("portInformationNeeded").writeValue(listServerNeighborsRequest.getPortInformationNeeded());
            }
            if ((neighborConfigurationIdsList = listServerNeighborsRequest.getNeighborConfigurationIds()) != null) {
                jsonGenerator.writeFieldName("neighborConfigurationIds");
                jsonGenerator.writeStartArray();
                for (String neighborConfigurationIdsListValue : neighborConfigurationIdsList) {
                    if (neighborConfigurationIdsListValue == null) continue;
                    jsonGenerator.writeValue(neighborConfigurationIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listServerNeighborsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listServerNeighborsRequest.getMaxResults());
            }
            if (listServerNeighborsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listServerNeighborsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

