/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.DeploymentCommandName;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DeploymentCommand
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalMap<String, List<String>> args;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentCommand withName(String name) {
        this.setName(name);
        return this;
    }

    public void setName(DeploymentCommandName name) {
        this.name = name.toString();
    }

    public DeploymentCommand withName(DeploymentCommandName name) {
        this.setName(name);
        return this;
    }

    public Map<String, List<String>> getArgs() {
        if (this.args == null) {
            this.args = new SdkInternalMap();
        }
        return this.args;
    }

    public void setArgs(Map<String, List<String>> args) {
        this.args = args == null ? null : new SdkInternalMap<String, List<String>>(args);
    }

    public DeploymentCommand withArgs(Map<String, List<String>> args) {
        this.setArgs(args);
        return this;
    }

    public DeploymentCommand addArgsEntry(String key, List<String> value) {
        if (null == this.args) {
            this.args = new SdkInternalMap();
        }
        if (this.args.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.args.put(key, value);
        return this;
    }

    public DeploymentCommand clearArgsEntries() {
        this.args = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: ").append(this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCommand)) {
            return false;
        }
        DeploymentCommand other = (DeploymentCommand)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || other.getArgs().equals(this.getArgs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : this.getArgs().hashCode());
        return hashCode;
    }

    public DeploymentCommand clone() {
        try {
            return (DeploymentCommand)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

