/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.worklink.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.worklink.model.WebsiteCaSummary;
import java.util.Date;

@SdkInternalApi
public class WebsiteCaSummaryMarshaller {
    private static final MarshallingInfo<String> WEBSITECAID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebsiteCaId").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").build();
    private static final WebsiteCaSummaryMarshaller instance = new WebsiteCaSummaryMarshaller();

    public static WebsiteCaSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(WebsiteCaSummary websiteCaSummary, ProtocolMarshaller protocolMarshaller) {
        if (websiteCaSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(websiteCaSummary.getWebsiteCaId(), WEBSITECAID_BINDING);
            protocolMarshaller.marshall(websiteCaSummary.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(websiteCaSummary.getDisplayName(), DISPLAYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

