/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.services.textract.model.Block;
import com.amazonaws.services.textract.model.Relationship;
import com.amazonaws.services.textract.model.transform.GeometryJsonUnmarshaller;
import com.amazonaws.services.textract.model.transform.RelationshipJsonUnmarshaller;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class BlockJsonUnmarshaller
implements Unmarshaller<Block, JsonUnmarshallerContext> {
    private static BlockJsonUnmarshaller instance;

    @Override
    public Block unmarshall(JsonUnmarshallerContext context) throws Exception {
        Block block = new Block();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BlockType", targetDepth)) {
                    context.nextToken();
                    block.setBlockType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    block.setConfidence(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("Text", targetDepth)) {
                    context.nextToken();
                    block.setText(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RowIndex", targetDepth)) {
                    context.nextToken();
                    block.setRowIndex(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ColumnIndex", targetDepth)) {
                    context.nextToken();
                    block.setColumnIndex(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("RowSpan", targetDepth)) {
                    context.nextToken();
                    block.setRowSpan(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ColumnSpan", targetDepth)) {
                    context.nextToken();
                    block.setColumnSpan(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("Geometry", targetDepth)) {
                    context.nextToken();
                    block.setGeometry(GeometryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    block.setId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Relationships", targetDepth)) {
                    context.nextToken();
                    block.setRelationships(new ListUnmarshaller<Relationship>(RelationshipJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EntityTypes", targetDepth)) {
                    context.nextToken();
                    block.setEntityTypes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("SelectionStatus", targetDepth)) {
                    context.nextToken();
                    block.setSelectionStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Page", targetDepth)) {
                    context.nextToken();
                    block.setPage(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return block;
    }

    public static BlockJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BlockJsonUnmarshaller();
        }
        return instance;
    }
}

