/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.textract.model.DocumentLocation;
import com.amazonaws.services.textract.model.FeatureType;
import com.amazonaws.services.textract.model.NotificationChannel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartDocumentAnalysisRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private DocumentLocation documentLocation;
    private List<String> featureTypes;
    private String clientRequestToken;
    private String jobTag;
    private NotificationChannel notificationChannel;

    public void setDocumentLocation(DocumentLocation documentLocation) {
        this.documentLocation = documentLocation;
    }

    public DocumentLocation getDocumentLocation() {
        return this.documentLocation;
    }

    public StartDocumentAnalysisRequest withDocumentLocation(DocumentLocation documentLocation) {
        this.setDocumentLocation(documentLocation);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public StartDocumentAnalysisRequest withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public StartDocumentAnalysisRequest withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public StartDocumentAnalysisRequest withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartDocumentAnalysisRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setJobTag(String jobTag) {
        this.jobTag = jobTag;
    }

    public String getJobTag() {
        return this.jobTag;
    }

    public StartDocumentAnalysisRequest withJobTag(String jobTag) {
        this.setJobTag(jobTag);
        return this;
    }

    public void setNotificationChannel(NotificationChannel notificationChannel) {
        this.notificationChannel = notificationChannel;
    }

    public NotificationChannel getNotificationChannel() {
        return this.notificationChannel;
    }

    public StartDocumentAnalysisRequest withNotificationChannel(NotificationChannel notificationChannel) {
        this.setNotificationChannel(notificationChannel);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentLocation() != null) {
            sb.append("DocumentLocation: ").append(this.getDocumentLocation()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getJobTag() != null) {
            sb.append("JobTag: ").append(this.getJobTag()).append(",");
        }
        if (this.getNotificationChannel() != null) {
            sb.append("NotificationChannel: ").append(this.getNotificationChannel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentAnalysisRequest)) {
            return false;
        }
        StartDocumentAnalysisRequest other = (StartDocumentAnalysisRequest)obj;
        if (other.getDocumentLocation() == null ^ this.getDocumentLocation() == null) {
            return false;
        }
        if (other.getDocumentLocation() != null && !other.getDocumentLocation().equals(this.getDocumentLocation())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        if (other.getFeatureTypes() != null && !other.getFeatureTypes().equals(this.getFeatureTypes())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getJobTag() == null ^ this.getJobTag() == null) {
            return false;
        }
        if (other.getJobTag() != null && !other.getJobTag().equals(this.getJobTag())) {
            return false;
        }
        if (other.getNotificationChannel() == null ^ this.getNotificationChannel() == null) {
            return false;
        }
        return other.getNotificationChannel() == null || other.getNotificationChannel().equals(this.getNotificationChannel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentLocation() == null ? 0 : this.getDocumentLocation().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getJobTag() == null ? 0 : this.getJobTag().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationChannel() == null ? 0 : this.getNotificationChannel().hashCode());
        return hashCode;
    }

    @Override
    public StartDocumentAnalysisRequest clone() {
        return (StartDocumentAnalysisRequest)super.clone();
    }
}

