/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.VolumeStatistics;

@SdkInternalApi
public class VolumeStatisticsMarshaller {
    private static final MarshallingInfo<Long> INBOXRAWCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboxRawCount").build();
    private static final MarshallingInfo<Long> SPAMRAWCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpamRawCount").build();
    private static final MarshallingInfo<Long> PROJECTEDINBOX_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectedInbox").build();
    private static final MarshallingInfo<Long> PROJECTEDSPAM_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectedSpam").build();
    private static final VolumeStatisticsMarshaller instance = new VolumeStatisticsMarshaller();

    public static VolumeStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(VolumeStatistics volumeStatistics, ProtocolMarshaller protocolMarshaller) {
        if (volumeStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(volumeStatistics.getInboxRawCount(), INBOXRAWCOUNT_BINDING);
            protocolMarshaller.marshall(volumeStatistics.getSpamRawCount(), SPAMRAWCOUNT_BINDING);
            protocolMarshaller.marshall(volumeStatistics.getProjectedInbox(), PROJECTEDINBOX_BINDING);
            protocolMarshaller.marshall(volumeStatistics.getProjectedSpam(), PROJECTEDSPAM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

