/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.PlacementStatistics;

@SdkInternalApi
public class PlacementStatisticsMarshaller {
    private static final MarshallingInfo<Double> INBOXPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InboxPercentage").build();
    private static final MarshallingInfo<Double> SPAMPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpamPercentage").build();
    private static final MarshallingInfo<Double> MISSINGPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MissingPercentage").build();
    private static final MarshallingInfo<Double> SPFPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpfPercentage").build();
    private static final MarshallingInfo<Double> DKIMPERCENTAGE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DkimPercentage").build();
    private static final PlacementStatisticsMarshaller instance = new PlacementStatisticsMarshaller();

    public static PlacementStatisticsMarshaller getInstance() {
        return instance;
    }

    public void marshall(PlacementStatistics placementStatistics, ProtocolMarshaller protocolMarshaller) {
        if (placementStatistics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(placementStatistics.getInboxPercentage(), INBOXPERCENTAGE_BINDING);
            protocolMarshaller.marshall(placementStatistics.getSpamPercentage(), SPAMPERCENTAGE_BINDING);
            protocolMarshaller.marshall(placementStatistics.getMissingPercentage(), MISSINGPERCENTAGE_BINDING);
            protocolMarshaller.marshall(placementStatistics.getSpfPercentage(), SPFPERCENTAGE_BINDING);
            protocolMarshaller.marshall(placementStatistics.getDkimPercentage(), DKIMPERCENTAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

