/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simpleemailv2.model.OverallVolume;
import java.util.List;

@SdkInternalApi
public class OverallVolumeMarshaller {
    private static final MarshallingInfo<StructuredPojo> VOLUMESTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeStatistics").build();
    private static final MarshallingInfo<Double> READRATEPERCENT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadRatePercent").build();
    private static final MarshallingInfo<List> DOMAINISPPLACEMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainIspPlacements").build();
    private static final OverallVolumeMarshaller instance = new OverallVolumeMarshaller();

    public static OverallVolumeMarshaller getInstance() {
        return instance;
    }

    public void marshall(OverallVolume overallVolume, ProtocolMarshaller protocolMarshaller) {
        if (overallVolume == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(overallVolume.getVolumeStatistics(), VOLUMESTATISTICS_BINDING);
            protocolMarshaller.marshall(overallVolume.getReadRatePercent(), READRATEPERCENT_BINDING);
            protocolMarshaller.marshall(overallVolume.getDomainIspPlacements(), DOMAINISPPLACEMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

