/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.DkimAttributes;
import java.util.List;

@SdkInternalApi
public class DkimAttributesMarshaller {
    private static final MarshallingInfo<Boolean> SIGNINGENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningEnabled").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<List> TOKENS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tokens").build();
    private static final DkimAttributesMarshaller instance = new DkimAttributesMarshaller();

    public static DkimAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(DkimAttributes dkimAttributes, ProtocolMarshaller protocolMarshaller) {
        if (dkimAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dkimAttributes.getSigningEnabled(), SIGNINGENABLED_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getTokens(), TOKENS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

