/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.Severity;

@SdkInternalApi
public class SeverityMarshaller {
    private static final MarshallingInfo<Double> PRODUCT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Product").build();
    private static final MarshallingInfo<Integer> NORMALIZED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Normalized").build();
    private static final SeverityMarshaller instance = new SeverityMarshaller();

    public static SeverityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Severity severity, ProtocolMarshaller protocolMarshaller) {
        if (severity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(severity.getProduct(), PRODUCT_BINDING);
            protocolMarshaller.marshall(severity.getNormalized(), NORMALIZED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

