/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.VPCConfig;
import java.util.List;

@SdkInternalApi
public class VPCConfigMarshaller {
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").build();
    private static final MarshallingInfo<List> SECURITYGROUPS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityGroups").build();
    private static final MarshallingInfo<Boolean> ASSIGNPUBLICIP_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("assignPublicIp").build();
    private static final VPCConfigMarshaller instance = new VPCConfigMarshaller();

    public static VPCConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(VPCConfig vPCConfig, ProtocolMarshaller protocolMarshaller) {
        if (vPCConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(vPCConfig.getSubnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(vPCConfig.getSecurityGroups(), SECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(vPCConfig.getAssignPublicIp(), ASSIGNPUBLICIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

