/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.services.robomaker.model.Source;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class SourceJsonUnmarshaller
implements Unmarshaller<Source, JsonUnmarshallerContext> {
    private static SourceJsonUnmarshaller instance;

    @Override
    public Source unmarshall(JsonUnmarshallerContext context) throws Exception {
        Source source = new Source();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("s3Bucket", targetDepth)) {
                    context.nextToken();
                    source.setS3Bucket(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3Key", targetDepth)) {
                    context.nextToken();
                    source.setS3Key(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("etag", targetDepth)) {
                    context.nextToken();
                    source.setEtag(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("architecture", targetDepth)) {
                    context.nextToken();
                    source.setArchitecture(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return source;
    }

    public static SourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceJsonUnmarshaller();
        }
        return instance;
    }
}

