/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.SourceConfig;

@SdkInternalApi
public class SourceConfigMarshaller {
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Key").build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("architecture").build();
    private static final SourceConfigMarshaller instance = new SourceConfigMarshaller();

    public static SourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(SourceConfig sourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (sourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(sourceConfig.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(sourceConfig.getS3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall(sourceConfig.getArchitecture(), ARCHITECTURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

