/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.PortMapping;

@SdkInternalApi
public class PortMappingMarshaller {
    private static final MarshallingInfo<Integer> JOBPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobPort").build();
    private static final MarshallingInfo<Integer> APPLICATIONPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationPort").build();
    private static final MarshallingInfo<Boolean> ENABLEONPUBLICIP_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enableOnPublicIp").build();
    private static final PortMappingMarshaller instance = new PortMappingMarshaller();

    public static PortMappingMarshaller getInstance() {
        return instance;
    }

    public void marshall(PortMapping portMapping, ProtocolMarshaller protocolMarshaller) {
        if (portMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(portMapping.getJobPort(), JOBPORT_BINDING);
            protocolMarshaller.marshall(portMapping.getApplicationPort(), APPLICATIONPORT_BINDING);
            protocolMarshaller.marshall(portMapping.getEnableOnPublicIp(), ENABLEONPUBLICIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

