/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.DataSourceConfig;
import java.util.List;

@SdkInternalApi
public class DataSourceConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<List> S3KEYS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Keys").build();
    private static final DataSourceConfigMarshaller instance = new DataSourceConfigMarshaller();

    public static DataSourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSourceConfig dataSourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (dataSourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataSourceConfig.getName(), NAME_BINDING);
            protocolMarshaller.marshall(dataSourceConfig.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(dataSourceConfig.getS3Keys(), S3KEYS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

