/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.services.robomaker.model.DataSourceConfig;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class DataSourceConfigJsonUnmarshaller
implements Unmarshaller<DataSourceConfig, JsonUnmarshallerContext> {
    private static DataSourceConfigJsonUnmarshaller instance;

    @Override
    public DataSourceConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3Bucket", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setS3Bucket(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("s3Keys", targetDepth)) {
                    context.nextToken();
                    dataSourceConfig.setS3Keys(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return dataSourceConfig;
    }

    public static DataSourceConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceConfigJsonUnmarshaller();
        }
        return instance;
    }
}

